/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kz.arta.synergy.forms.common.object.ASFData;
import kz.arta.synergy.forms.common.util.ASFDataUtils;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ASFDataWrapper {
    private String nodeUUID;
    private String uuid;
    private String form;
    private Integer formVersion;
    private String modified;
    private List<ASFData.Data> data;

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public Integer getFormVersion() {
        return this.formVersion;
    }

    public void setFormVersion(Integer formVersion) {
        this.formVersion = formVersion;
    }

    public String getModified() {
        return this.modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public List<ASFData.Data> getData() {
        return this.data;
    }

    public ASFData.Data getData(String cmpID) {
        if (this.data != null) {
            for (ASFData.Data d : this.data) {
                if (!d.getId().equalsIgnoreCase(cmpID)) continue;
                return d;
            }
        }
        return null;
    }

    public ASFData.Data getData(String cmpID, boolean searchInsideTables) {
        if (!searchInsideTables) {
            return this.getData(cmpID);
        }
        if (this.data != null) {
            for (ASFData.Data d : this.data) {
                if (d.getData() != null && d.getData().size() > 0) {
                    for (ASFData.Data innerData : d.getData()) {
                        if (!innerData.getId().equalsIgnoreCase(cmpID)) continue;
                        return innerData;
                    }
                    continue;
                }
                if (!d.getId().equalsIgnoreCase(cmpID)) continue;
                return d;
            }
        }
        return null;
    }

    public List<ASFData.Data> getAllDataById(String cmpID, boolean includeDynamic) {
        ArrayList<ASFData.Data> result = new ArrayList<ASFData.Data>();
        for (ASFData.Data data : this.data) {
            if (data == null) continue;
            if (cmpID.equals(data.getId())) {
                result.add(data);
            }
            if (!includeDynamic || data.getData() == null) continue;
            for (ASFData.Data dynData : data.getData()) {
                if (!cmpID.equals(ASFDataUtils.getBlockComponentId(dynData.getId()))) continue;
                result.add(dynData);
            }
        }
        return result;
    }

    public void setData(List<ASFData.Data> data) {
        this.data = data;
    }

    public String getNodeUUID() {
        return this.nodeUUID;
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    public boolean equals(Object obj) {
        boolean equals;
        String id;
        ASFData.Data d1;
        if (!(obj instanceof ASFDataWrapper)) {
            return false;
        }
        ASFDataWrapper data = (ASFDataWrapper)obj;
        for (ASFData.Data d : data.getData()) {
            equals = this.equalsData(d, d1 = this.getData(id = d.getId()));
            if (equals) continue;
            return false;
        }
        for (ASFData.Data d : this.getData()) {
            equals = this.equalsData(d, d1 = data.getData(id = d.getId()));
            if (equals) continue;
            return false;
        }
        return true;
    }

    private boolean equalsData(ASFData.Data d, ASFData.Data d1) {
        if (d1 == null || !(d1.getValue() + "").equals(d.getValue() + "")) {
            return false;
        }
        if (d.getData() != null && d1.getData() != null) {
            for (ASFData.Data childData : d.getData()) {
                ASFData.Data childData1;
                boolean equals = this.equalsData(childData, childData1 = d1.getData(childData.getId()));
                if (equals) continue;
                return false;
            }
        }
        return true;
    }

    public void mixin(List<ASFData.Data> mixin) {
        if (mixin == null) {
            return;
        }
        HashMap<String, ASFData.Data> idsMap = new HashMap<String, ASFData.Data>();
        for (ASFData.Data data : mixin) {
            String id = data.getId();
            if (id == null || id.isEmpty()) continue;
            idsMap.put(id, data);
        }
        ArrayList<ASFData.Data> mixed = new ArrayList<ASFData.Data>();
        for (ASFData.Data data : this.data) {
            if (idsMap.containsKey(data.getId())) {
                mixed.add((ASFData.Data)idsMap.get(data.getId()));
                continue;
            }
            mixed.add(data);
        }
        this.data = mixed;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

