/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kz.arta.synergy.forms.common.object.ASFData;
import kz.arta.synergy.forms.common.object.ASFDataSources;
import kz.arta.synergy.forms.common.object.ASFLayout;
import kz.arta.synergy.forms.common.object.WidgetType;
import kz.arta.synergy.forms.common.object.translation.EntityText;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ASFProperty {
    private String id;
    private String type;
    private String label;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private List<EntityText> translations;
    private Style style;
    private List<ASFProperty> properties;
    private ASFLayout layout;
    private Config config;
    private ASFData.Data data;
    private ASFDataSources dataSource;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ASFData.Data getData() {
        return this.data;
    }

    public void setData(ASFData.Data data) {
        this.data = data;
    }

    public ASFDataSources getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ASFDataSources dataSource) {
        this.dataSource = dataSource;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public List<ASFProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ASFProperty> properties) {
        this.properties = properties;
    }

    public ASFLayout getLayout() {
        return this.layout;
    }

    public void setLayout(ASFLayout layout) {
        this.layout = layout;
    }

    public List<EntityText> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<EntityText> translations) {
        this.translations = translations;
    }

    public ASFProperty getASFProperty(String cmpID) {
        if (this.properties != null && cmpID != null) {
            for (ASFProperty property : this.properties) {
                if (!cmpID.equalsIgnoreCase(property.getId())) continue;
                return property;
            }
        }
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public static boolean hasCycleLink(Map<String, String> links, String initialCmpID, String cmpID, String firstCmpID) {
        String depend = links.get(cmpID);
        if (initialCmpID == null) {
            return false;
        }
        if (depend != null) {
            if (depend.equals(initialCmpID)) {
                return true;
            }
            if (firstCmpID.equals(depend)) {
                return false;
            }
            return ASFProperty.hasCycleLink(links, initialCmpID, depend, firstCmpID);
        }
        return false;
    }

    public static boolean alreadyHasCycleLink(Map<String, String> links, String initialCmpID, String cmpID) {
        if (cmpID == null) {
            return false;
        }
        return cmpID.equals(links.get(initialCmpID)) && ASFProperty.hasCycleLink(links, initialCmpID, cmpID, cmpID);
    }

    public static class Builder {
        private ASFProperty property = new ASFProperty();

        public Builder id(String id) {
            this.property.id = id;
            return this;
        }

        public Builder type(String type) {
            this.property.type = type;
            return this;
        }

        public Builder type(WidgetType type) {
            this.property.type = type.name();
            return this;
        }

        public Builder config(Config config) {
            this.property.config = config;
            return this;
        }

        private List<ASFProperty> getProperties() {
            if (this.property.properties == null) {
                this.property.properties = new ArrayList();
            }
            return this.property.properties;
        }

        public Builder property(ASFProperty property) {
            this.getProperties().add(property);
            return this;
        }

        public Builder properties(List<ASFProperty> properties) {
            this.getProperties().addAll(properties);
            return this;
        }

        public ASFProperty build() {
            return this.property;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Config {
        String dsType;
        boolean rpActiv;
        int rpCount;
        boolean round = false;
        boolean drop;
        boolean tsActive;
        String tsValue;
        String field;
        boolean appendRows = false;
        String delimeter;
        String component;
        String url;
        String counter;
        boolean fillWithCurrent;
        boolean fillWithParent;
        String entity;
        String locale;
        String dateFormat;
        String linked;
        String depends;
        private int type = -1;
        private boolean addSpace;
        private String format;
        private Map<String, String> customNameFormats;

        public Map<String, String> getCustomNameFormats() {
            return this.customNameFormats;
        }

        public void setCustomNameFormats(Map<String, String> customNameFormats) {
            this.customNameFormats = customNameFormats;
        }

        @JsonProperty(value="format")
        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        @JsonProperty(value="field")
        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        @JsonProperty(value="DS_TYPE")
        public String getDsType() {
            return this.dsType;
        }

        public void setDsType(String dsType) {
            this.dsType = dsType;
        }

        @JsonProperty(value="RP_ACTIV")
        public boolean isRpActiv() {
            return this.rpActiv;
        }

        public void setRpActiv(boolean rpActiv) {
            this.rpActiv = rpActiv;
        }

        @JsonProperty(value="RP_COUNT")
        public int getRpCount() {
            return this.rpCount;
        }

        public void setRpCount(int rpCount) {
            this.rpCount = rpCount;
        }

        @JsonProperty(value="ROUND")
        public boolean getRound() {
            return this.round;
        }

        public void setRound(boolean Round) {
            this.round = Round;
        }

        @JsonProperty(value="DROP")
        public boolean getDrop() {
            return this.drop;
        }

        public void setDrop(boolean Drop) {
            this.drop = Drop;
        }

        @JsonProperty(value="TS_ACTIVE")
        public boolean getTsActive() {
            return this.tsActive;
        }

        public void setTsActive(boolean tsActive) {
            this.tsActive = tsActive;
        }

        @JsonProperty(value="TS_VALUE")
        public String getTsValue() {
            return this.tsValue;
        }

        public void setTsValue(String tsValue) {
            this.tsValue = tsValue;
        }

        public boolean isAppendRows() {
            return this.appendRows;
        }

        public void setAppendRows(boolean appendRows) {
            this.appendRows = appendRows;
        }

        public String getUrl() {
            return this.url;
        }

        public String getCounter() {
            return this.counter;
        }

        @JsonProperty(value="fill-with-current")
        public boolean isFillWithCurrent() {
            return this.fillWithCurrent;
        }

        @JsonProperty(value="fillWithParent")
        public boolean isFillWithParent() {
            return this.fillWithParent;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public String getLinked() {
            return this.linked;
        }

        public String getDepends() {
            return this.depends;
        }

        public void setDepends(String depends) {
            this.depends = depends;
        }

        @JsonProperty(value="type")
        public int getType() {
            return this.type;
        }

        public void setType(int i) {
            this.type = i;
        }

        @JsonProperty(value="add-space")
        public boolean isAddSpace() {
            return this.addSpace;
        }

        public void setAddSpace(boolean addSpace) {
            this.addSpace = addSpace;
        }

        @JsonProperty(value="delimeter")
        public String getDelimeter() {
            return this.delimeter;
        }

        public void setDelimeter(String delimeter) {
            this.delimeter = delimeter;
        }

        @JsonProperty(value="component")
        public String getComponent() {
            return this.component;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Style {
        private String width;
        private String height;
        private String align;
        private String font;
        private String fontsize;
        private boolean bold = false;
        private boolean italic = false;
        private boolean underline = false;
        private boolean strike = false;
        private String border;
        private boolean wrap = false;

        public String getWidth() {
            return this.width;
        }

        public String getHeight() {
            return this.height;
        }

        public String getAlign() {
            return this.align;
        }

        public String getFont() {
            return this.font;
        }

        public String getFontsize() {
            return this.fontsize;
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public boolean isStrike() {
            return this.strike;
        }

        public String getBorder() {
            return this.border;
        }

        public boolean isWrap() {
            return this.wrap;
        }

        public void setWrap(boolean wrap) {
            this.wrap = wrap;
        }
    }
}

