/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object.printer.foElements;

import kz.arta.synergy.forms.common.object.printer.foElements.FOInline;
import kz.arta.synergy.forms.common.object.printer.foElements.FoTagElement;
import kz.arta.synergy.forms.common.util.printer.TextUtilits;

public class FOBlock
implements FoTagElement {
    private String font = "Arial";
    private String fontSize = "8pt";
    private boolean isBold = false;
    private int boldCount = 0;
    private boolean isItalic = false;
    private int italicCount = 0;
    private boolean isUnderline = false;
    private int underlineCount = 0;
    private boolean isStrike = false;
    private int strikeCount = 0;
    private String fontColor = "";
    private String backColor = "";
    private TextUtilits.TEXT_ALIGN textAlign = TextUtilits.TEXT_ALIGN.START;
    private int marginLeft = 0;
    private static double marginLiftCoof = 0.5;
    private boolean isNumeric = false;
    private int numericCount = 0;
    private int numberLi = 0;
    private boolean wasNumber = false;
    private boolean isPunkted = false;
    private int punktedCount = 0;
    private String borderWidth = "";

    @Override
    public String[][] asFoBlock() {
        int count = this.getCountParams();
        int i = 0;
        String[][] result = new String[count + 1][];
        if (this.getFont() != null && !this.getFont().equals("")) {
            result[i] = new String[]{"font-family", this.getFont()};
            ++i;
        }
        if (this.getFontSize() != null && !this.getFontSize().equals("")) {
            result[i] = new String[]{"font-size", this.getFontSize()};
            ++i;
        }
        if (this.isBold()) {
            result[i] = new String[]{"font-weight", "bold"};
            ++i;
        } else {
            result[i] = new String[]{"font-weight", "normal"};
            ++i;
        }
        if (this.isItalic()) {
            result[i] = new String[]{"font-style", "italic"};
            ++i;
        } else {
            result[i] = new String[]{"font-style", "normal"};
            ++i;
        }
        if (this.isUnderline() || this.isStrike()) {
            if (this.isUnderline() && this.isStrike()) {
                result[i] = new String[]{"text-decoration", "underline line-through"};
                ++i;
            } else if (this.isUnderline()) {
                result[i] = new String[]{"text-decoration", "underline"};
                ++i;
            } else if (this.isStrike()) {
                result[i] = new String[]{"text-decoration", "line-through"};
                ++i;
            } else {
                result[i] = new String[]{"text-decoration", "ZOMBI APOKALIPSIS"};
                ++i;
            }
        }
        if (this.getFontColor() != null && !this.getFontColor().equals("")) {
            result[i] = new String[]{"color", this.getFontColor()};
            ++i;
        }
        if (this.getBackColor() != null && !this.getBackColor().equals("")) {
            result[i] = new String[]{"background-color", this.getBackColor()};
            ++i;
        }
        if (this.getTextAlign() != TextUtilits.TEXT_ALIGN.NULL) {
            result[i] = new String[]{"text-align", this.textAlign.toString().toLowerCase()};
            ++i;
        }
        if (this.marginLeft != 0) {
            result[i] = new String[]{"margin-left", (double)this.marginLeft * marginLiftCoof + "cm"};
            ++i;
        }
        if (!"".equals(this.borderWidth)) {
            result[i] = new String[]{"border-width", this.borderWidth};
            ++i;
        }
        result[result.length - 1] = new String[]{"fo:block"};
        return result;
    }

    public String[][] asFoInline() {
        String[][] result = this.asFoBlock();
        result[result.length - 1] = new String[]{"fo:inline"};
        return result;
    }

    private int getCountParams() {
        int count = 0;
        if (this.getFont() != null && !this.getFont().equals("")) {
            ++count;
        }
        if (this.getFontSize() != null && !this.getFontSize().equals("")) {
            ++count;
        }
        ++count;
        ++count;
        if (this.isUnderline() || this.isStrike()) {
            ++count;
        }
        if (this.getFontColor() != null && !this.getFontColor().equals("")) {
            ++count;
        }
        if (this.getBackColor() != null && !this.getBackColor().equals("")) {
            ++count;
        }
        if (this.getTextAlign() != TextUtilits.TEXT_ALIGN.NULL) {
            ++count;
        }
        if (this.marginLeft != 0) {
            ++count;
        }
        if (!"".equals(this.borderWidth)) {
            ++count;
        }
        return count;
    }

    public void getCopyFrom(FOBlock clone) {
        this.font = clone.getFont();
        this.fontSize = clone.getFontSize();
        this.isBold = clone.isBold();
        this.boldCount = clone.getBoldCount();
        this.isItalic = clone.isItalic();
        this.italicCount = clone.getItalicCount();
        this.isUnderline = clone.isUnderline();
        this.underlineCount = clone.getUnderlineCount();
        this.isStrike = clone.isStrike();
        this.strikeCount = clone.getStrikeCount();
        this.fontColor = clone.getFontColor();
        this.backColor = clone.getBackColor();
        this.textAlign = clone.getTextAlign();
        this.marginLeft = clone.getMarginLeft();
        this.isNumeric = clone.isNumeric();
        this.numberLi = clone.getNumberLi();
        this.isPunkted = clone.isPunkted();
        this.numericCount = clone.getNumericCount();
        this.borderWidth = clone.getBorderWidth();
    }

    public FOBlock clone() {
        FOBlock temp = new FOBlock();
        temp.setFont(this.font);
        temp.setFontSize(this.fontSize);
        temp.setBold(this.isBold);
        temp.setBoldCount(this.boldCount);
        temp.setItalic(this.isItalic);
        temp.setItalicCount(this.italicCount);
        temp.setUnderline(this.isUnderline);
        temp.setUnderlineCount(this.underlineCount);
        temp.setStrike(this.isStrike);
        temp.setStrikeCount(this.strikeCount);
        temp.setFontColor(this.fontColor);
        temp.setBackColor(this.backColor);
        temp.setTextAlign(this.textAlign);
        temp.setMarginLeft(this.marginLeft);
        temp.setNumeric(this.isNumeric);
        temp.setNumberLi(this.numberLi);
        temp.setPunkted(this.isPunkted);
        temp.setNumericCount(this.numericCount);
        temp.setBorderWidth(this.borderWidth);
        return temp;
    }

    public FOBlock reset() {
        this.font = "Arial";
        this.fontSize = "8pt";
        this.isBold = false;
        this.boldCount = 0;
        this.isItalic = false;
        this.italicCount = 0;
        this.isUnderline = false;
        this.underlineCount = 0;
        this.isStrike = false;
        this.strikeCount = 0;
        this.fontColor = "";
        this.backColor = "";
        this.textAlign = TextUtilits.TEXT_ALIGN.START;
        this.marginLeft = 0;
        this.isNumeric = false;
        this.numberLi = 0;
        this.punktedCount = 0;
        this.isPunkted = false;
        this.numericCount = 0;
        this.borderWidth = "";
        return this;
    }

    public String getFont() {
        return this.font;
    }

    @Override
    public FOBlock setFont(String font) {
        this.font = font;
        return this;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    @Override
    public FOBlock setFontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public boolean isBold() {
        return this.isBold;
    }

    @Override
    public FOBlock setBold(boolean bold) {
        if (bold) {
            ++this.boldCount;
            this.isBold = bold;
        } else {
            if (this.boldCount > 0) {
                --this.boldCount;
            }
            if (this.boldCount == 0) {
                this.isBold = bold;
            }
        }
        return this;
    }

    public int getBoldCount() {
        return this.boldCount;
    }

    public void setBoldCount(int boldCount) {
        this.boldCount = boldCount;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    @Override
    public FOBlock setItalic(boolean italic) {
        if (italic) {
            ++this.italicCount;
            this.isItalic = italic;
        } else {
            if (this.italicCount > 0) {
                --this.italicCount;
            }
            if (this.italicCount == 0) {
                this.isItalic = italic;
            }
        }
        return this;
    }

    @Override
    public int getItalicCount() {
        return this.italicCount;
    }

    public void setItalicCount(int italicCount) {
        this.italicCount = italicCount;
    }

    public boolean isUnderline() {
        return this.isUnderline;
    }

    @Override
    public FOBlock setUnderline(boolean underline) {
        if (underline) {
            ++this.underlineCount;
            this.isUnderline = underline;
        } else {
            if (this.underlineCount > 0) {
                --this.underlineCount;
            }
            if (this.underlineCount == 0) {
                this.isUnderline = underline;
            }
        }
        return this;
    }

    @Override
    public int getUnderlineCount() {
        return this.underlineCount;
    }

    public void setUnderlineCount(int underlineCount) {
        this.underlineCount = underlineCount;
    }

    public boolean isStrike() {
        return this.isStrike;
    }

    @Override
    public FOBlock setStrike(boolean strike) {
        if (strike) {
            ++this.strikeCount;
            this.isStrike = strike;
        } else {
            if (this.strikeCount > 0) {
                --this.strikeCount;
            }
            if (this.strikeCount == 0) {
                this.isStrike = strike;
            }
        }
        return this;
    }

    @Override
    public int getStrikeCount() {
        return this.strikeCount;
    }

    public void setStrikeCount(int strikeCount) {
        this.strikeCount = strikeCount;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    @Override
    public FOBlock setFontColor(String fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public String getBackColor() {
        return this.backColor;
    }

    @Override
    public FOBlock setBackColor(String backColor) {
        this.backColor = backColor;
        return this;
    }

    public TextUtilits.TEXT_ALIGN getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextUtilits.TEXT_ALIGN textAlign) {
        this.textAlign = textAlign;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public int setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft < 0 ? 0 : marginLeft;
        return this.marginLeft;
    }

    public static void setMarginLiftCoof(double marginLiftCoofCM) {
        marginLiftCoof = marginLiftCoofCM;
    }

    public static double getmarginLiftCoof() {
        return marginLiftCoof;
    }

    public static String getmarginLiftCoofCM() {
        return marginLiftCoof + "cm";
    }

    public int addmMarginLift() {
        ++this.marginLeft;
        return this.marginLeft;
    }

    public int removeMarginLift() {
        --this.marginLeft;
        if (this.marginLeft < 0) {
            this.marginLeft = 0;
        }
        return this.marginLeft;
    }

    public int addmMarginLift(int i) {
        this.marginLeft = i;
        return this.marginLeft;
    }

    public int removeMarginLift(int i) {
        this.marginLeft = -i;
        if (this.marginLeft < 0) {
            this.marginLeft = 0;
        }
        return this.marginLeft;
    }

    public void setNumeric(boolean isNumeric) {
        if (isNumeric) {
            this.isNumeric = isNumeric;
            ++this.numericCount;
            this.numberLi = 1;
        }
        if (!isNumeric) {
            --this.numericCount;
            if (this.numericCount == 0) {
                this.isNumeric = isNumeric;
            }
        }
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public int getNumberLi() {
        return this.numberLi;
    }

    public void setNumberLi(int numberLi) {
        this.numberLi = numberLi;
    }

    public int addLi() {
        if (this.isNumeric) {
            ++this.numberLi;
        }
        this.wasNumber = false;
        return this.numberLi;
    }

    public String numberMod(String str) {
        if (!this.wasNumber && this.isNumeric()) {
            str = this.numberLi + ".\t" + str;
            this.wasNumber = true;
        } else if (!this.wasNumber && this.isPunkted) {
            char tempChar = '\u00a0';
            String tempString = tempChar + "" + tempChar + "" + tempChar + "" + tempChar;
            if (this.punktedCount == 1) {
                str = "\u25cf\t" + str;
            }
            if (this.punktedCount == 2) {
                str = tempString + "\u25cb\t" + str;
            }
            if (this.punktedCount == 3) {
                str = tempString + tempString + "\u25a0\t" + str;
            }
            if (this.punktedCount > 3) {
                String tempStr = str;
                str = "";
                for (int i = 1; i < this.punktedCount; ++i) {
                    str = str + tempString;
                }
                str = str + "\u25a0\t" + tempStr;
            }
            this.wasNumber = true;
        }
        return str;
    }

    public boolean isPunkted() {
        return this.isPunkted;
    }

    public void setPunkted(boolean punkted) {
        if (punkted) {
            ++this.punktedCount;
            this.isPunkted = punkted;
        }
        if (!punkted) {
            --this.punktedCount;
            if (this.punktedCount == 0) {
                this.isPunkted = punkted;
            }
        }
    }

    public int getNumericCount() {
        return this.numericCount;
    }

    public void setNumericCount(int numericCount) {
        this.numericCount = numericCount;
    }

    public static String[][] getClean() {
        return new FOBlock().asFoBlock();
    }

    public String getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(String borderWidth) {
        this.borderWidth = borderWidth;
    }

    public String toString() {
        String[][] resultArray = this.asFoBlock();
        String resultStr = resultArray[resultArray.length - 1][0];
        for (int i = 1; i < resultArray.length - 1; ++i) {
            resultStr = resultStr + " " + resultArray[i][0] + " " + resultArray[i][1];
        }
        return resultStr;
    }

    @Override
    public FoTagElement.Type getType() {
        return FoTagElement.Type.FoBlock;
    }

    public FOInline getAsInLine() {
        FOInline result = new FOInline();
        result.setFont(this.font);
        result.setFontSize(this.fontSize);
        result.setBold(this.isBold);
        result.setBoldCount(this.boldCount);
        result.setItalic(this.isItalic);
        result.setItalicCount(this.italicCount);
        result.setUnderline(this.isUnderline);
        result.setUnderlineCount(this.underlineCount);
        result.setStrike(this.isStrike);
        result.setStrikeCount(this.strikeCount);
        result.setFontColor(this.fontColor);
        result.setBackColor(this.backColor);
        result.setTextAlign(this.textAlign);
        result.setBorderWidth(this.borderWidth);
        return result;
    }
}

