/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object.printer.foElements;

import kz.arta.synergy.forms.common.object.printer.foElements.FoTagElement;
import kz.arta.synergy.forms.common.util.printer.TextUtilits;

public class FOInline
implements FoTagElement {
    private String font = "Arial";
    private String fontSize = "8pt";
    private boolean isBold = false;
    private int boldCount = 0;
    private boolean isItalic = false;
    private int italicCount = 0;
    private boolean isUnderline = false;
    private int underlineCount = 0;
    private boolean isStrike = false;
    private int strikeCount = 0;
    private TextUtilits.TEXT_ALIGN textAlign = TextUtilits.TEXT_ALIGN.START;
    private String fontColor = "";
    private String backColor = "";
    private FOInline spanStyle = null;
    private String borderWidth = "normal";

    public String[][] asFoInline() {
        FOInline tempThis = this.spanStyle == null ? this : this.spanStyle;
        int count = this.getCountParams();
        int i = 0;
        String[][] result = new String[count + 1][];
        if (tempThis.getFont() != null && !tempThis.getFont().equals("")) {
            result[i] = new String[]{"font-family", tempThis.getFont()};
            ++i;
        }
        if (tempThis.getFontSize() != null && !tempThis.getFontSize().equals("")) {
            result[i] = new String[]{"font-size", tempThis.getFontSize()};
            ++i;
        }
        if (tempThis.isBold()) {
            result[i] = new String[]{"font-weight", "bold"};
            ++i;
        } else {
            result[i] = new String[]{"font-weight", "normal"};
            ++i;
        }
        if (tempThis.isItalic()) {
            result[i] = new String[]{"font-style", "italic"};
            ++i;
        } else {
            result[i] = new String[]{"font-style", "normal"};
            ++i;
        }
        if (tempThis.isUnderline() || tempThis.isStrike()) {
            if (tempThis.isUnderline() && tempThis.isStrike()) {
                result[i] = new String[]{"text-decoration", "underline line-through"};
                ++i;
            } else if (tempThis.isUnderline()) {
                result[i] = new String[]{"text-decoration", "underline"};
                ++i;
            } else if (tempThis.isStrike()) {
                result[i] = new String[]{"text-decoration", "line-through"};
                ++i;
            } else {
                result[i] = new String[]{"text-decoration", "ZOMBI APOKALIPSIS"};
                ++i;
            }
        }
        if (tempThis.getFontColor() != null && !tempThis.getFontColor().equals("")) {
            result[i] = new String[]{"color", tempThis.getFontColor()};
            ++i;
        }
        if (tempThis.getBackColor() != null && !tempThis.getBackColor().equals("")) {
            result[i] = new String[]{"background-color", tempThis.getBackColor()};
            ++i;
        }
        if (this.getTextAlign() != TextUtilits.TEXT_ALIGN.NULL) {
            result[i] = new String[]{"text-align", this.textAlign.toString().toLowerCase()};
            ++i;
        }
        if (!"".equals(this.borderWidth)) {
            result[i] = new String[]{"border-width", this.borderWidth};
            ++i;
        }
        result[result.length - 1] = new String[]{"fo:inline"};
        return result;
    }

    private int getCountParams() {
        FOInline tempThis = this.spanStyle == null ? this : this.spanStyle;
        int count = 0;
        if (tempThis.getFont() != null && !tempThis.getFont().equals("")) {
            ++count;
        }
        if (tempThis.getFontSize() != null && !tempThis.getFontSize().equals("")) {
            ++count;
        }
        ++count;
        ++count;
        if (tempThis.isUnderline() || tempThis.isStrike()) {
            ++count;
        }
        if (tempThis.getFontColor() != null && !tempThis.getFontColor().equals("")) {
            ++count;
        }
        if (tempThis.getBackColor() != null && !tempThis.getBackColor().equals("")) {
            ++count;
        }
        if (tempThis.getTextAlign() != null && tempThis.getTextAlign() != TextUtilits.TEXT_ALIGN.NULL) {
            ++count;
        }
        if (!"".equals(this.borderWidth)) {
            ++count;
        }
        return count;
    }

    public void getCopyFrom(FOInline clone) {
        this.font = clone.getFont();
        this.fontSize = clone.getFontSize();
        this.isBold = clone.isBold;
        this.boldCount = clone.getBoldCount();
        this.isItalic = clone.isItalic;
        this.italicCount = clone.getItalicCount();
        this.isUnderline = clone.isUnderline;
        this.underlineCount = clone.getUnderlineCount();
        this.isStrike = clone.isStrike;
        this.strikeCount = clone.getStrikeCount();
        this.fontColor = clone.getFontColor();
        this.backColor = clone.getBackColor();
        this.spanStyle = clone.getSpanStyle();
        this.textAlign = clone.getTextAlign();
        this.borderWidth = clone.getBorderWidth();
    }

    public FOInline clone() {
        FOInline temp = new FOInline();
        temp.setFont(this.font);
        temp.setFontSize(this.fontSize);
        temp.setBold(this.isBold);
        temp.setBoldCount(this.boldCount);
        temp.setItalic(this.isItalic);
        temp.setItalicCount(this.italicCount);
        temp.setUnderline(this.isUnderline);
        temp.setUnderlineCount(this.underlineCount);
        temp.setStrike(this.isStrike);
        temp.setStrikeCount(this.strikeCount);
        temp.setFontColor(this.fontColor);
        temp.setBackColor(this.backColor);
        temp.setSpanStyleForClone(this.spanStyle);
        temp.setBorderWidth(this.borderWidth);
        return temp;
    }

    private FOInline cloneForSpan() {
        FOInline temp = new FOInline();
        temp.setFont(this.font);
        temp.setFontSize(this.fontSize);
        temp.setBold(this.isBold);
        temp.setBoldCount(this.boldCount);
        temp.setItalic(this.isItalic);
        temp.setItalicCount(this.italicCount);
        temp.setUnderline(this.isUnderline);
        temp.setUnderlineCount(this.underlineCount);
        temp.setStrike(this.isStrike);
        temp.setStrikeCount(this.strikeCount);
        temp.setFontColor(this.fontColor);
        temp.setBackColor(this.backColor);
        temp.setSpanStyleForClone(this.clone());
        temp.setTextAlign(this.textAlign);
        temp.setBorderWidth(this.borderWidth);
        return temp;
    }

    public String getFont() {
        return this.font;
    }

    @Override
    public FOInline setFont(String font) {
        this.font = font;
        return this;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    @Override
    public FOInline setFontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public boolean isBold() {
        return this.isBold;
    }

    @Override
    public FOInline setBold(boolean bold) {
        if (bold) {
            ++this.boldCount;
            this.isBold = bold;
        } else {
            if (this.boldCount > 0) {
                --this.boldCount;
            }
            if (this.boldCount == 0) {
                this.isBold = bold;
            }
        }
        return this;
    }

    public int getBoldCount() {
        return this.boldCount;
    }

    public void setBoldCount(int boldCount) {
        this.boldCount = boldCount;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    @Override
    public FOInline setItalic(boolean italic) {
        if (italic) {
            ++this.italicCount;
            this.isItalic = italic;
        } else {
            if (this.italicCount > 0) {
                --this.italicCount;
            }
            if (this.italicCount == 0) {
                this.isItalic = italic;
            }
        }
        return this;
    }

    @Override
    public int getItalicCount() {
        return this.italicCount;
    }

    public void setItalicCount(int italicCount) {
        this.italicCount = italicCount;
    }

    public boolean isUnderline() {
        return this.isUnderline;
    }

    @Override
    public FOInline setUnderline(boolean underline) {
        if (underline) {
            ++this.underlineCount;
            this.isUnderline = underline;
        } else {
            if (this.underlineCount > 0) {
                --this.underlineCount;
            }
            if (this.underlineCount == 0) {
                this.isUnderline = underline;
            }
        }
        return this;
    }

    @Override
    public int getUnderlineCount() {
        return this.underlineCount;
    }

    public void setUnderlineCount(int underlineCount) {
        this.underlineCount = underlineCount;
    }

    public boolean isStrike() {
        return this.isStrike;
    }

    @Override
    public FOInline setStrike(boolean strike) {
        if (strike) {
            ++this.strikeCount;
            this.isStrike = strike;
        } else {
            if (this.strikeCount > 0) {
                --this.strikeCount;
            }
            if (this.strikeCount == 0) {
                this.isStrike = strike;
            }
        }
        return this;
    }

    @Override
    public int getStrikeCount() {
        return this.strikeCount;
    }

    public void setStrikeCount(int strikeCount) {
        this.strikeCount = strikeCount;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    @Override
    public FOInline setFontColor(String fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public String getBackColor() {
        return this.backColor;
    }

    @Override
    public FOInline setBackColor(String backColor) {
        this.backColor = backColor;
        return this;
    }

    public FOInline setSpanStyle() {
        this.spanStyle = this.cloneForSpan();
        return this;
    }

    public FOInline setSpanStyleForClone(FOInline spanStyle) {
        this.spanStyle = spanStyle;
        return this;
    }

    public FOInline removeSapnStyle() {
        this.spanStyle = null;
        return this;
    }

    public FOInline getSpanStyle() {
        return this.spanStyle;
    }

    public TextUtilits.TEXT_ALIGN getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextUtilits.TEXT_ALIGN textAlign) {
        this.textAlign = textAlign;
    }

    public String getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(String borderWidth) {
        this.borderWidth = borderWidth;
    }

    @Override
    public FoTagElement.Type getType() {
        return FoTagElement.Type.FoInline;
    }

    @Override
    public String[][] asFoBlock() {
        String[][] result = this.asFoInline();
        result[result.length - 1] = new String[]{"fo:block"};
        return result;
    }
}

