/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object.printer.foElements;

import kz.arta.synergy.forms.common.util.printer.TextUtilits;

public class FOTableCell {
    private TextUtilits.AZIMUTH cellAzimut = TextUtilits.AZIMUTH.CENTER;
    private TextUtilits.BACKGROUND_ATTACHMENT cellBackgroundAttachment = TextUtilits.BACKGROUND_ATTACHMENT.SCROLL;
    private String cellBackgroundColor = null;
    private String cellBorder = null;
    private int cellNumberColumnsSpanned = 0;
    private int cellNumberRowsSpanned = 0;
    private int cellHeightCm = -1;
    private int cellWidthCm = -1;
    private String cellBackgroundImage = "";
    private TextUtilits.BACKGROUND_REPEAT cellBackgroundRepeat = TextUtilits.BACKGROUND_REPEAT.NULL;
    private String cellBackgroundPositionHorizontal = null;
    private String cellBackgroundPositionVertical = null;
    private String cellPaddingLeft = "0.3 cm";
    private String cellPaddingTop = "0.3 cm";
    private String cellPaddingRight = "0.3 cm";
    private String cellPaddingBottom = "0.3 cm";

    private int getCellCountParams() {
        int count = 0;
        if (this.getCellAzimuth() != TextUtilits.AZIMUTH.MY_OUTSIDE) {
            ++count;
        }
        if (this.getCellBackgroundAttachment() != TextUtilits.BACKGROUND_ATTACHMENT.SCROLL) {
            ++count;
        }
        if (this.getCellBackgroundColor() != null) {
            ++count;
        }
        if (this.getCellPaddingLeft() != null) {
            ++count;
        }
        if (this.getCellPaddingTop() != null) {
            ++count;
        }
        if (this.getCellPaddingRight() != null) {
            ++count;
        }
        if (this.getCellPaddingBottom() != null) {
            ++count;
        }
        if (this.isCellBorder()) {
            ++count;
        }
        if (this.getCellNumberColumnsSpanned() > 1) {
            ++count;
        }
        if (this.getCellNumberRowsSpanned() > 1) {
            ++count;
        }
        if (this.getCellHeightCm() != -1) {
            ++count;
        }
        if (this.getCellWidthCm() != -1) {
            ++count;
        }
        if (this.getCellBackgroundImage() != null) {
            ++count;
        }
        if (this.getCellBackgroundRepeat() != TextUtilits.BACKGROUND_REPEAT.NULL) {
            ++count;
        }
        if (this.getCellBackgroundPositionHorizontal() != null) {
            ++count;
        }
        if (this.getCellBackgroundPositionVertical() != null) {
            ++count;
        }
        return count;
    }

    public String[][] asFoTableCell() {
        int count = this.getCellCountParams();
        int i = 0;
        String[][] result = new String[count + 1][];
        if (this.getCellAzimuth() != TextUtilits.AZIMUTH.MY_OUTSIDE) {
            result[i] = new String[]{"azimuth", this.getStringCellAzimuth()};
            ++i;
        }
        if (this.getCellBackgroundAttachment() != TextUtilits.BACKGROUND_ATTACHMENT.SCROLL) {
            result[i] = new String[]{"background-attachment", this.getStringCellBackgroundAttachment()};
            ++i;
        }
        if (this.getCellBackgroundColor() != null) {
            result[i] = new String[]{"background-color", this.getCellBackgroundColor()};
            ++i;
        }
        if (this.getCellPaddingLeft() != null) {
            result[i] = new String[]{"padding-left", this.getCellPaddingLeft()};
            ++i;
        }
        if (this.getCellPaddingLeft() != null) {
            result[i] = new String[]{"padding-top", this.getCellPaddingTop()};
            ++i;
        }
        if (this.getCellPaddingLeft() != null) {
            result[i] = new String[]{"padding-right", this.getCellPaddingRight()};
            ++i;
        }
        if (this.getCellPaddingLeft() != null) {
            result[i] = new String[]{"padding-bottom", this.getCellPaddingBottom()};
            ++i;
        }
        if (this.isCellBorder()) {
            result[i] = new String[]{"border", this.getCellBorder()};
            ++i;
        }
        if (this.getCellNumberColumnsSpanned() > 1) {
            result[i] = new String[]{"number-columns-spanned", this.getCellNumberColumnsSpanned() + ""};
            ++i;
        }
        if (this.getCellNumberRowsSpanned() > 1) {
            result[i] = new String[]{"number-rows-spanned", this.getCellNumberRowsSpanned() + ""};
            ++i;
        }
        if (this.getCellHeightCm() != -1) {
            result[i] = new String[]{"height", this.getCellHeightCm() + "cm"};
            ++i;
        }
        if (this.getCellWidthCm() != -1) {
            result[i] = new String[]{"width", this.getCellWidthCm() + "cm"};
            ++i;
        }
        if (this.getCellBackgroundImage() != null) {
            result[i] = new String[]{"background-image", this.getCellBackgroundImage()};
            ++i;
        }
        if (this.getCellBackgroundRepeat() != TextUtilits.BACKGROUND_REPEAT.NULL) {
            result[i] = new String[]{"background-repeat", this.getStringCellBackgroundRepeat()};
            ++i;
        }
        if (this.getCellBackgroundPositionHorizontal() != null) {
            result[i] = new String[]{"background-position-horizontal", this.getCellBackgroundPositionHorizontal()};
            ++i;
        }
        if (this.getCellBackgroundPositionVertical() != null) {
            result[i] = new String[]{"background-position-vertical", this.getCellBackgroundPositionVertical()};
            ++i;
        }
        result[i] = new String[]{"fo:table-cell"};
        return result;
    }

    public void setCellAzimuth(TextUtilits.AZIMUTH azimuth) {
        this.cellAzimut = azimuth;
    }

    public TextUtilits.AZIMUTH getCellAzimuth() {
        return this.cellAzimut;
    }

    public String getStringCellAzimuth() {
        return this.cellAzimut.toString().toLowerCase();
    }

    public TextUtilits.BACKGROUND_ATTACHMENT getCellBackgroundAttachment() {
        return this.cellBackgroundAttachment;
    }

    public String getStringCellBackgroundAttachment() {
        return this.cellBackgroundAttachment.toString().toLowerCase();
    }

    public void setCellBackgroundAttachment(TextUtilits.BACKGROUND_ATTACHMENT backgroundAttachment) {
        this.cellBackgroundAttachment = backgroundAttachment;
    }

    public String getCellBackgroundColor() {
        return this.cellBackgroundColor;
    }

    public void setCellBackgroundColor(String backgroundColor) {
        this.cellBackgroundColor = backgroundColor;
    }

    public void setCellBackgroundTransparent() {
        this.cellBackgroundColor = "transparent";
    }

    public String getCellPaddingLeft() {
        return this.cellPaddingLeft;
    }

    public void setCellPaddingLeft(String paddingLeft) {
        this.cellPaddingLeft = paddingLeft;
    }

    public String getCellPaddingTop() {
        return this.cellPaddingTop;
    }

    public void setCellPaddingTop(String paddingTop) {
        this.cellPaddingTop = paddingTop;
    }

    public String getCellPaddingRight() {
        return this.cellPaddingRight;
    }

    public void setCellPaddingRight(String paddingRight) {
        this.cellPaddingRight = paddingRight;
    }

    public String getCellPaddingBottom() {
        return this.cellPaddingBottom;
    }

    public void setCellPaddingBottom(String paddingBottom) {
        this.cellPaddingBottom = paddingBottom;
    }

    public String getCellBorder() {
        return this.cellBorder;
    }

    public void setCellBorder(String border) {
        this.cellBorder = border;
    }

    public void setCellBorder() {
        this.cellBorder = "solid black 1px";
    }

    public boolean isCellBorder() {
        return this.cellBorder != null;
    }

    public int getCellNumberColumnsSpanned() {
        return this.cellNumberColumnsSpanned;
    }

    public void setCellNumberColumnsSpanned(int numberColumnsSpanned) {
        this.cellNumberColumnsSpanned = numberColumnsSpanned;
    }

    public int getCellNumberRowsSpanned() {
        return this.cellNumberRowsSpanned;
    }

    public void setCellNumberRowsSpanned(int numberRowsSpanned) {
        this.cellNumberRowsSpanned = numberRowsSpanned;
    }

    public int getCellHeightCm() {
        return this.cellHeightCm;
    }

    public void resetCellHeightCm() {
        this.cellHeightCm = -1;
    }

    public void setCellHeightCm(int heightCm) {
        this.cellHeightCm = heightCm;
    }

    public int getCellWidthCm() {
        return this.cellWidthCm;
    }

    public void resetCellWidthCm() {
        this.cellWidthCm = -1;
    }

    public void setCellWidthCm(int widthCm) {
        this.cellWidthCm = widthCm;
    }

    public String getCellBackgroundImage() {
        return this.cellBackgroundImage;
    }

    public void setCellBackgroundImage(String backgroundImage) {
        this.cellBackgroundImage = backgroundImage;
    }

    public void setCellBackgroundImageNone() {
        this.cellBackgroundImage = "none";
    }

    public TextUtilits.BACKGROUND_REPEAT getCellBackgroundRepeat() {
        return this.cellBackgroundRepeat;
    }

    public String getStringCellBackgroundRepeat() {
        return this.cellBackgroundRepeat.toString().toLowerCase();
    }

    public void setCellBackgroundRepeat(TextUtilits.BACKGROUND_REPEAT backgroundRepeat) {
        this.cellBackgroundRepeat = backgroundRepeat;
    }

    public void resetCellBackgroundRepeat() {
        this.cellBackgroundRepeat = TextUtilits.BACKGROUND_REPEAT.NULL;
    }

    public String getCellBackgroundPositionHorizontal() {
        return this.cellBackgroundPositionHorizontal;
    }

    public void setCellBackgroundPositionHorizontal(String backgroundPositionHorizontal) {
        this.cellBackgroundPositionHorizontal = backgroundPositionHorizontal;
    }

    public String getCellBackgroundPositionVertical() {
        return this.cellBackgroundPositionVertical;
    }

    public void setCellBackgroundPositionVertical(String backgroundPositionVertical) {
        this.cellBackgroundPositionVertical = backgroundPositionVertical;
    }
}

