/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object.shared;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Map;
import kz.arta.synergy.forms.common.exception.ASFDefinitionException;
import kz.arta.synergy.forms.common.object.shared.ASFStatusConst;

public class ASFStatusUtils {
    public static String errorProcessing(ASFDefinitionException exception) {
        if (exception.getProblemFields() != null && exception.getProblemFields().contains(ASFStatusConst.CODE_EXIST.getCode())) {
            return ASFStatusConst.CODE_EXIST.getCode();
        }
        if (exception.getProblemFields() != null && exception.getProblemFields().contains(ASFStatusConst.CODE_NUM_ERROR.getCode())) {
            return ASFStatusConst.CODE_NUM_ERROR.getCode();
        }
        return null;
    }

    public static void checkResultInt(PrintWriter writer, ByteArrayOutputStream buffer, String selectedForm, Map<String, Object> importingForms, int result) {
        if (writer == null) {
            return;
        }
        if (buffer == null || importingForms == null) {
            writer.write(ASFStatusConst.FALSE.getCode());
            return;
        }
        ASFStatusConst status = ASFStatusConst.getByValue(result);
        switch (status) {
            case CODE_EXIST: {
                writer.write(ASFStatusConst.CODE_EXIST.getCode());
                break;
            }
            case CONFIRM: {
                importingForms.put(selectedForm, buffer);
                writer.write(ASFStatusConst.CONFIRM.getCode());
                break;
            }
            case TRUE: {
                writer.write(ASFStatusConst.TRUE.getCode());
                break;
            }
            default: {
                writer.write(ASFStatusConst.FALSE.getCode());
            }
        }
    }

    public static void checkResultString(PrintWriter writer, String result) {
        if (result == null) {
            writer.write(ASFStatusConst.FALSE.getCode());
        } else if (ASFStatusConst.CODE_EXIST.getCode().equals(result)) {
            writer.write(ASFStatusConst.CODE_EXIST.getCode());
        } else if (ASFStatusConst.CODE_NUM_ERROR.getCode().equals(result)) {
            writer.write(ASFStatusConst.FALSE.getCode());
        } else {
            writer.write(ASFStatusConst.TRUE.getCode());
        }
    }
}

