/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kz.arta.synergy.forms.common.exception.ASFDefinitionException;
import kz.arta.synergy.forms.common.object.ASFCollatedDefinition;
import kz.arta.synergy.forms.common.object.ASFData;
import kz.arta.synergy.forms.common.object.ASFDataWrapper;
import kz.arta.synergy.forms.common.object.ASFDefaultValue;
import kz.arta.synergy.forms.common.object.ASFDefinition;
import kz.arta.synergy.forms.common.object.ASFPrintableTemplates;
import kz.arta.synergy.forms.common.object.ASFProperties;
import kz.arta.synergy.forms.common.object.ASFProperty;
import kz.arta.synergy.forms.common.object.WidgetType;
import kz.arta.synergy.forms.common.object.collation.CollatedCard;
import kz.arta.synergy.forms.common.util.Json;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper MAPPER = Json.mapper();

    private JsonUtil() {
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getParamValue(String json, String paramName) {
        String value = null;
        JsonParser jp = null;
        try {
            JsonFactory f = new JsonFactory();
            jp = f.createJsonParser(json);
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = jp.getCurrentName();
                jp.nextToken();
                if (!paramName.equalsIgnoreCase(fieldname)) continue;
                value = jp.getText();
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jp.close();
            }
            catch (IOException iOException) {}
        }
        return value;
    }

    public static String wrapASFDataJSON(String uuid, String form, Timestamp modified, int version, int formVersion, String nodeUUID, String data) {
        return "{\"uuid\":\"" + uuid + "\", " + "\"version\":" + version + ", " + "\"form\":\"" + form + "\", " + "\"formVersion\":" + formVersion + ", " + "\"modified\":\"" + modified + "\", " + "\"nodeUUID\":\"" + nodeUUID + "\", " + "" + data + "}";
    }

    public static String wrapASFormJSON(String uuid, String formDef) {
        return "{\"uuid\":\"" + uuid + "\", " + formDef + "}";
    }

    public static String wrapASFormJSON(String uuid, String name, String nameru, String namekz, String code, int version, String description, String formDef, String layout, String mobUUID, String mobLayout, String mobDefinition, String printUUID, String printLayout, String printDefinition) {
        String views = "";
        if (mobUUID != null || printUUID != null) {
            views = ", \"views\" : [";
            if (mobUUID != null) {
                views = views + "\n {\"uuid\" : " + JsonUtil.quoteValue(mobUUID) + ", " + "\"typeform\": \"1\", " + "\"layout\" : " + JsonUtil.quoteValue(mobLayout) + "" + (mobDefinition == null || mobDefinition.length() < 3 ? "" : ", " + mobDefinition) + "}";
                if (printUUID != null) {
                    views = views + ",";
                }
            }
            if (printUUID != null) {
                views = views + "\n {\"uuid\" : " + JsonUtil.quoteValue(printUUID) + ", " + "\"typeform\": \"2\", " + "\"layout\" : " + JsonUtil.quoteValue(printLayout) + "" + (printDefinition == null || printDefinition.length() < 3 ? "" : ", " + printDefinition) + "}";
            }
            views = views + "]";
        }
        return "{" + (!"".equals(uuid) ? "\"uuid\":\"" + uuid + "\"" + ", \"version\":" + version + ", \"typeform\":" + JsonUtil.quoteValue("0") + ", \"name\":" + JsonUtil.quoteValue(name) + ", \"nameru\":" + JsonUtil.quoteValue(nameru != null ? nameru : "") + ", \"namekz\":" + JsonUtil.quoteValue(namekz != null ? namekz : "") + ", \"code\":" + JsonUtil.quoteValue(code != null ? code : "") + ", \"description\":" + JsonUtil.quoteValue(description) + ", " + formDef + ",\n \"layout\":{" + JsonUtil.formatLayout(layout) + "}" : "") + views + "}";
    }

    public static String wrapASFormJSON(String uuid, String name, String nameru, String namekz, String code, int version, String descr, String formDef, String layout) {
        return JsonUtil.wrapASFormJSON(uuid, name, nameru, namekz, code, version, descr, formDef, layout, null, null, null, null, null, null);
    }

    public static String wrapASFormJSON(String uuid, String name, String nameru, String namekz, String descr, String formDef, String layout, String mobUUID, String mobDefinition, String mobLayout, String printUUID, String printLayout, String printDefinition) {
        return "{\"uuid\":\"" + uuid + "\", \"name\":" + JsonUtil.quoteValue(name) + ", \"nameru\":" + JsonUtil.quoteValue(nameru != null ? nameru : "") + ", \"namekz\":" + JsonUtil.quoteValue(namekz != null ? namekz : "") + ", \"description\":" + JsonUtil.quoteValue(descr) + ", " + formDef + ", " + "\"typeform\":" + JsonUtil.quoteValue("0") + ",\n \"layout\":{" + JsonUtil.formatLayout(layout) + "}" + ",\n \"views\":[" + "{\"uuid\":\"" + mobUUID + "\"" + ", " + "\"typeform\":" + JsonUtil.quoteValue("1") + ", " + mobDefinition + ",\n \"layout\":{" + JsonUtil.formatLayout(mobLayout) + "}" + "}" + (printUUID != null && printUUID.length() > 1 ? "\n {\"uuid\" : " + JsonUtil.quoteValue(printUUID) + ", " + "\"typeform\":" + JsonUtil.quoteValue("2") : "") + (printLayout != null && printLayout.length() > 1 ? ", \"layout\" : " + JsonUtil.quoteValue(printLayout) : "") + (printDefinition != null && printDefinition.length() > 1 ? ", " + printDefinition + "}" : "") + "]}";
    }

    public static String formatLayout(String layout) {
        if (layout.startsWith("\"columns\":")) {
            layout = "\"totalPages\":1, \"pages\":[{\"page\":1," + layout + "}]";
        }
        return layout;
    }

    @Deprecated
    public static ASFData getASFData(String data) {
        try {
            return JsonUtil.getUnsafeASFData(data);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ASFData getUnsafeASFData(String data) throws IOException {
        return (ASFData)MAPPER.readValue(data, ASFData.class);
    }

    public static boolean validateASFData(String data) {
        try {
            MAPPER.readValue(data, ASFData.class);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static ASFDataWrapper readASFDataWrapper(String jsonString) {
        ASFDataWrapper wrapper = null;
        try {
            wrapper = (ASFDataWrapper)MAPPER.readValue(jsonString, ASFDataWrapper.class);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return wrapper;
    }

    public static ASFDefinition readASFDefinition(String jsonString) {
        ASFDefinition definition = null;
        try {
            definition = (ASFDefinition)MAPPER.readValue(jsonString, ASFDefinition.class);
            definition = JsonUtil.subLoadDefaultValuesForDefinition(jsonString, definition);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return definition;
    }

    public static List<CollatedCard> readCollationFromASFDefinition(String jsonString) {
        ASFCollatedDefinition definition = null;
        ArrayList<CollatedCard> result = new ArrayList<CollatedCard>();
        try {
            definition = (ASFCollatedDefinition)MAPPER.readValue(jsonString, ASFCollatedDefinition.class);
            result.addAll(definition.getCollations());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static ASFDefinition subLoadDefaultValuesForDefinition(String jsonString, ASFDefinition definition) {
        try {
            JsonNode node = MAPPER.readTree(jsonString);
            if (definition.getData() != null) {
                node = node.get("data");
                for (int i = 0; i < node.size(); ++i) {
                    int j;
                    if (node.get(i).get("default") != null) {
                        if (node.get(i).get("default").isTextual()) {
                            definition.getData().get(i).setDefaultValue(node.get(i).get("default").asText());
                        } else if (node.get(i).get("default").isArray()) {
                            for (j = 0; j < node.get(i).get("default").size(); ++j) {
                                if (!node.get(i).get("default").get(j).isTextual()) continue;
                                definition.getData().get(i).addDefaultValue(node.get(i).get("default").get(j).asText());
                            }
                        }
                    }
                    if (node.get(i).get("data") == null) continue;
                    for (j = 0; j < node.get(i).get("data").size(); ++j) {
                        if (node.get(i).get("data").get(j).get("default") == null) continue;
                        if (node.get(i).get("data").get(j).get("default").isTextual()) {
                            definition.getData().get(i).getData().get(j).setDefaultValue(node.get(i).get("data").get(j).get("default").asText());
                            continue;
                        }
                        if (!node.get(i).get("default").isArray()) continue;
                        for (int k = 0; k < node.get(i).get("data").get(j).get("default").size(); ++k) {
                            if (!node.get(i).get("data").get(j).get("default").get(k).isTextual()) continue;
                            definition.getData().get(i).getData().get(j).addDefaultValue(node.get(i).get("data").get(j).get("default").get(k).asText());
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return definition;
    }

    public static ASFProperties readASFProperties(String json) {
        ASFProperties properties = null;
        try {
            properties = (ASFProperties)MAPPER.readValue(json, ASFProperties.class);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return properties;
    }

    public static List<String> listASFProperties(String json) {
        ASFProperties props = JsonUtil.readASFProperties(json);
        ArrayList<String> propsList = new ArrayList<String>();
        for (ASFProperty property : props.getProperties()) {
            if (property.getProperties() != null) {
                for (ASFProperty innerProperty : property.getProperties()) {
                    propsList.add(innerProperty.getId());
                }
                continue;
            }
            propsList.add(property.getId());
        }
        return propsList;
    }

    public static ASFDefaultValue readASFDefaultValue(String json) {
        ASFDefaultValue defaultValue = null;
        try {
            defaultValue = (ASFDefaultValue)MAPPER.readValue(json, ASFDefaultValue.class);
            defaultValue = JsonUtil.subLoadDefaultValue(json, defaultValue);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return defaultValue;
    }

    private static ASFDefaultValue subLoadDefaultValue(String jsonString, ASFDefaultValue defaultValue) {
        try {
            JsonNode node = MAPPER.readTree(jsonString);
            if (defaultValue != null) {
                if (node.get("default") != null) {
                    if (node.get("default").isTextual()) {
                        defaultValue.setDefaultValue(node.get("default").asText());
                    } else if (node.get("default").isArray()) {
                        for (int j = 0; j < node.get("default").size(); ++j) {
                            if (!node.get("default").get(j).isTextual()) continue;
                            defaultValue.addDefaultValue(node.get("default").get(j).asText());
                        }
                    }
                }
                if (node.get("data") != null) {
                    for (int i = 0; i < node.get("data").size(); ++i) {
                        if (node.get("data").get(i).get("default") == null) continue;
                        if (node.get("data").get(i).get("default").isTextual()) {
                            defaultValue.getData().get(i).setDefaultValue(node.get("data").get(i).get("default").asText());
                            continue;
                        }
                        if (!node.get("data").get(i).get("default").isArray()) continue;
                        for (int j = 0; j < node.get("data").get(i).get("default").size(); ++j) {
                            if (!node.get("data").get(i).get("default").get(j).isTextual()) continue;
                            defaultValue.getData().get(i).addDefaultValue(node.get("data").get(i).get("default").get(j).asText());
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return defaultValue;
    }

    public static List<String> listASFInputProperties(String json) {
        return JsonUtil.listASFInputProperties(json, false);
    }

    public static List<String> listASFInputProperties(String json, boolean includeDynamic) {
        ASFProperties props = JsonUtil.readASFProperties(json);
        LinkedList<String> propsList = new LinkedList<String>();
        if (props != null && props.getProperties() != null) {
            for (ASFProperty property : props.getProperties()) {
                if (property.getProperties() != null) {
                    if (property.getConfig() != null && property.getConfig().isAppendRows()) {
                        propsList.add(property.getId());
                        if (!includeDynamic) continue;
                        for (ASFProperty innerProperty : property.getProperties()) {
                            if (!WidgetType.valueOf(innerProperty.getType()).isInput()) continue;
                            propsList.add(property.getId() + "." + innerProperty.getId());
                        }
                        continue;
                    }
                    for (ASFProperty innerProperty : property.getProperties()) {
                        if (!WidgetType.valueOf(innerProperty.getType()).isInput()) continue;
                        propsList.add(innerProperty.getId());
                    }
                    continue;
                }
                if (!WidgetType.valueOf(property.getType()).isInput()) continue;
                propsList.add(property.getId());
            }
        }
        return propsList;
    }

    public static Map<String, WidgetType> listAllSingleInputs(String json, List<WidgetType> allowedTypes, boolean includeDynamic) {
        ASFProperties props = JsonUtil.readASFProperties(json);
        return JsonUtil.listAllSingleInputs(props, allowedTypes, includeDynamic);
    }

    static Map<String, WidgetType> listAllSingleInputs(ASFProperties props, List<WidgetType> allowedTypes, boolean includeDynamic) {
        if (props == null) {
            return Collections.emptyMap();
        }
        return JsonUtil.listAllSingleInputs(props.getProperties(), allowedTypes, includeDynamic);
    }

    static Map<String, WidgetType> listAllSingleInputs(List<ASFProperty> props, final List<WidgetType> allowedTypes, final boolean includeDynamic) {
        if (props == null) {
            return Collections.emptyMap();
        }
        FluentIterable resultProps = FluentIterable.from(props).transformAndConcat((Function)new Function<ASFProperty, List<ASFProperty>>(){

            public List<ASFProperty> apply(ASFProperty input) {
                return JsonUtil.getProperties(input, includeDynamic);
            }
        }).filter((Predicate)new Predicate<ASFProperty>(){

            public boolean apply(ASFProperty input) {
                if (allowedTypes == null) {
                    return true;
                }
                WidgetType type = WidgetType.getFromProperty(input);
                return type != null && allowedTypes.contains((Object)type);
            }
        });
        HashMap<String, WidgetType> result = new HashMap<String, WidgetType>();
        for (ASFProperty prop : resultProps) {
            result.put(prop.getId(), WidgetType.getFromProperty(prop));
        }
        return result;
    }

    public static List<ASFProperty> getProperties(ASFProperty property, boolean includeDynamic) {
        boolean isDynamic;
        if (property == null || property.getProperties() == null) {
            return Collections.singletonList(property);
        }
        boolean bl = isDynamic = property.getConfig() != null && property.getConfig().isAppendRows();
        if (isDynamic) {
            property.setType(WidgetType.appendable_table.name());
            if (!includeDynamic) {
                return Collections.singletonList(property);
            }
        }
        ArrayList<ASFProperty> tableProps = new ArrayList<ASFProperty>();
        if (isDynamic) {
            tableProps.add(property);
        }
        for (ASFProperty innerProp : property.getProperties()) {
            if (isDynamic) {
                innerProp.setId(property.getId() + "." + innerProp.getId());
            }
            tableProps.add(innerProp);
        }
        return tableProps;
    }

    public static List<String> listASFSingleInputProperties(String json) {
        ASFProperties props = JsonUtil.readASFProperties(json);
        ArrayList<String> propsList = new ArrayList<String>();
        for (ASFProperty property : props.getProperties()) {
            if (!(property.getProperties() == null || property.getConfig() != null && property.getConfig().isAppendRows())) {
                for (ASFProperty innerProperty : property.getProperties()) {
                    if (!WidgetType.valueOf(innerProperty.getType()).isInput() || WidgetType.table.name().equals(innerProperty.getType())) continue;
                    propsList.add(innerProperty.getId());
                }
                continue;
            }
            if (!WidgetType.valueOf(property.getType()).isInput()) continue;
            propsList.add(property.getId());
        }
        return propsList;
    }

    public static String quoteValue(String value) {
        if (value != null) {
            try {
                return MAPPER.writeValueAsString((Object)value);
            }
            catch (IOException e) {
                return value;
            }
        }
        return null;
    }

    public static String extractASFUuid(String json) {
        ObjectNode root = JsonUtil.getRootNode(json);
        if (root != null) {
            try {
                return root.get("uuid").getTextValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String extractASFName(String json, String locale) {
        ObjectNode root = JsonUtil.getRootNode(json);
        if (root != null) {
            try {
                return root.get("name" + locale).getTextValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String extractASFCode(String json) {
        ObjectNode root = JsonUtil.getRootNode(json);
        if (root != null) {
            try {
                return root.get("code").getTextValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String extractASFDescription(String json) {
        ObjectNode root = JsonUtil.getRootNode(json);
        if (root != null) {
            try {
                return root.get("description").getTextValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String extractASFDefinition(String json) {
        ObjectNode root = JsonUtil.getRootNode(json);
        if (root != null) {
            try {
                root.remove(Arrays.asList("uuid", "name", "nameru", "namekz", "description", "layout", "version"));
                String definition = root.toString();
                definition = definition.substring(1, definition.length() - 1);
                return definition;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String extractASFLayout(String json) {
        ObjectNode root = JsonUtil.getRootNode(json);
        if (root != null && root.get("layout") != null) {
            try {
                String layout = root.get("layout").toString();
                layout = layout.substring(1, layout.length() - 1);
                return layout;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String getFieldValue(String json, String fieldName) {
        ObjectNode root = JsonUtil.getRootNode(json);
        if (root != null && root.get(fieldName) != null) {
            try {
                String value = root.get(fieldName).toString();
                value = value.substring(1, value.length() - 1);
                return value;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static ObjectNode getRootNode(String json) {
        try {
            JsonParser jp = MAPPER.getJsonFactory().createJsonParser(json);
            return (ObjectNode)MAPPER.readTree(jp);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String toJSON(Object obj) {
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String toShortJSON(Object obj) {
        String newDataJSON = JsonUtil.toJSON(obj);
        if (newDataJSON != null) {
            return newDataJSON.substring(1, newDataJSON.length() - 1);
        }
        return null;
    }

    public static ASFData.Data copyData(ASFData.Data data) {
        try {
            String dataJSON = MAPPER.writeValueAsString((Object)data);
            return (ASFData.Data)MAPPER.readValue(dataJSON, ASFData.Data.class);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<ASFData.Data> getFieldValuesByType(WidgetType type, ASFData asfData) {
        ArrayList<ASFData.Data> values = new ArrayList<ASFData.Data>();
        for (ASFData.Data data : asfData.getData()) {
            if (data.getType().equals(type.name())) {
                values.add(data);
            }
            if (data.getData() == null) continue;
            for (ASFData.Data dynTableData : data.getData()) {
                if (!dynTableData.getType().equals(type.name())) continue;
                values.add(dynTableData);
            }
        }
        return values;
    }

    public static void checkProblemFields(String defStr) throws ASFDefinitionException {
        ASFDefinition definition;
        try {
            definition = (ASFDefinition)MAPPER.readValue(defStr, ASFDefinition.class);
        }
        catch (IOException e) {
            throw new ASFDefinitionException();
        }
        HashSet<String> wrong = new HashSet<String>();
        HashSet<String> objects = new HashSet<String>();
        JsonUtil.parseDefinition(definition.getProperties(), wrong, objects, "");
        if (!wrong.isEmpty()) {
            throw new ASFDefinitionException().setProblemFields(wrong.toArray(new String[wrong.size()]));
        }
    }

    private static void parseDefinition(List<ASFProperty> props, Set<String> wrong, Set<String> objects, String prefix) {
        for (ASFProperty prop : props) {
            if (prop == null || prop.getId() == null) continue;
            if (!objects.add(prefix + prop.getId())) {
                wrong.add(prefix + prop.getId());
            }
            if (prop.getProperties() == null) continue;
            if (prop.getConfig() != null && prop.getConfig().isAppendRows()) {
                JsonUtil.parseDefinition(prop.getProperties(), wrong, objects, prop.getId() + ".");
                continue;
            }
            JsonUtil.parseDefinition(prop.getProperties(), wrong, objects, "");
        }
    }

    public static ASFPrintableTemplates parsePrintableTemplates(String json) {
        ASFPrintableTemplates result = null;
        try {
            result = (ASFPrintableTemplates)MAPPER.readValue(json, ASFPrintableTemplates.class);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static JsonNode readTree(String content) throws IOException {
        return MAPPER.readTree(content);
    }

    public static <T> T read(String result, Class<T> classType) throws IOException {
        return (T)MAPPER.readValue(result, classType);
    }

    static {
        MAPPER.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

