/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.conf;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import kz.arta.util.index.conf.ConfigurationManager;
import kz.arta.util.index.conf.ElasticIndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="configuration")
@XmlType
public class ElasticConfiguration {
    public static final String CONFIG_PROPERTY_NAME = "elastic.configuration.path";
    static final Logger LOGGER = LoggerFactory.getLogger(ElasticConfiguration.class);
    private String url = "http://localhost:9200/";
    private ElasticIndexSettings forms = new ElasticIndexSettings();
    private ElasticIndexSettings docs = new ElasticIndexSettings();
    private ElasticIndexSettings files = new ElasticIndexSettings();
    private static ElasticConfiguration instance = null;

    @XmlElement(name="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ElasticIndexSettings getForms() {
        return this.forms;
    }

    @XmlElement(name="forms")
    public void setForms(ElasticIndexSettings forms) {
        this.forms = forms;
    }

    public ElasticIndexSettings getDocs() {
        return this.docs;
    }

    @XmlElement(name="docs")
    public void setDocs(ElasticIndexSettings docs) {
        this.docs = docs;
    }

    public ElasticIndexSettings getFiles() {
        return this.files;
    }

    @XmlElement(name="files")
    public void setFiles(ElasticIndexSettings files) {
        this.files = files;
    }

    public static synchronized void readConfiguration(String configFile) {
        try {
            instance = ConfigurationManager.readConfiguration(configFile, ElasticConfiguration.class);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            instance = new ElasticConfiguration();
        }
    }

    public static ElasticIndexSettings getFormsConf() {
        return ElasticConfiguration.getInstance().getForms();
    }

    public static ElasticIndexSettings getDocsConf() {
        return ElasticConfiguration.getInstance().getDocs();
    }

    public static ElasticIndexSettings getFilesConf() {
        return ElasticConfiguration.getInstance().getFiles();
    }

    public static ElasticConfiguration getInstance() {
        return instance;
    }
}

