/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.conf;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import kz.arta.util.string.StringUtil;

@XmlRootElement(name="history")
@XmlType
public class ElasticHistoryIndex {
    private List<String> indexTemplates = new ArrayList<String>();
    private List<String> indexPatterns = new ArrayList<String>();

    @XmlElement(name="template")
    public List<String> getIndexTemplates() {
        return this.indexTemplates;
    }

    public void setIndexTemplates(List<String> indexTemplates) {
        this.indexTemplates = indexTemplates;
        this.escapePatterns();
    }

    public void escapePatterns() {
        for (String pattern : this.indexTemplates) {
            String regExp = StringUtil.escapeTemplate(pattern);
            this.indexPatterns.add(regExp);
        }
    }

    public boolean isNeedHistoryIndex(String indexName) {
        for (String pattern : this.indexPatterns) {
            if (!indexName.matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

