/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.conf;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import kz.arta.util.index.conf.ConfigurationManager;
import kz.arta.util.index.conf.LuceneIndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="configuration")
@XmlType
public class LuceneConfiguration {
    public static final String CONFIG_PROPERTY_NAME = "lucene.configuration.path";
    static final Logger LOGGER = LoggerFactory.getLogger(LuceneConfiguration.class);
    private LuceneIndexSettings docs = new LuceneIndexSettings();
    private LuceneIndexSettings forms = new LuceneIndexSettings();
    private LuceneIndexSettings files = new LuceneIndexSettings();
    private static LuceneConfiguration instance = null;

    public LuceneIndexSettings getForms() {
        return this.forms;
    }

    @XmlElement(name="forms")
    public void setForms(LuceneIndexSettings forms) {
        this.forms = forms;
    }

    public LuceneIndexSettings getDocs() {
        return this.docs;
    }

    @XmlElement(name="docs")
    public void setDocs(LuceneIndexSettings docs) {
        this.docs = docs;
    }

    public LuceneIndexSettings getFiles() {
        return this.files;
    }

    @XmlElement(name="files")
    public void setFiles(LuceneIndexSettings files) {
        this.files = files;
    }

    public static synchronized void readConfiguration(String configFile) {
        try {
            instance = ConfigurationManager.readConfiguration(configFile, LuceneConfiguration.class);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            instance = new LuceneConfiguration();
        }
    }

    public static LuceneConfiguration getInstance() {
        return instance;
    }

    public static LuceneIndexSettings getFormIndex() {
        return LuceneConfiguration.getInstance().getForms();
    }

    public static LuceneIndexSettings getDocIndex() {
        return LuceneConfiguration.getInstance().getDocs();
    }

    public static LuceneIndexSettings getFileIndex() {
        return LuceneConfiguration.getInstance().getFiles();
    }
}

