/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class HttpBasicOperation {
    public static ObjectMapper mapper = new ObjectMapper();

    public HttpURLConnection openPostConnection(URL url) throws IOException {
        return this.openPostConnection(url, null);
    }

    public HttpURLConnection openPostConnection(URL url, String auth) throws IOException {
        return this.openConnection(url, "POST", auth, null, null);
    }

    public HttpURLConnection openPostConnection(URL url, String auth, String accept) throws IOException {
        return this.openConnection(url, "POST", auth, accept, null);
    }

    public HttpURLConnection openPostConnection(URL url, String auth, String accept, String contentType) throws IOException {
        return this.openConnection(url, "POST", auth, accept, contentType);
    }

    public HttpURLConnection openDeleteConnection(URL url) throws IOException {
        return this.openConnection(url, "DELETE", null, null, null);
    }

    public HttpURLConnection openGetConnection(URL url) throws IOException {
        return this.openGetConnection(url, null);
    }

    public HttpURLConnection openGetConnection(URL url, String auth) throws IOException {
        return this.openGetConnection(url, auth, null);
    }

    public HttpURLConnection openGetConnection(URL url, String auth, String accept) throws IOException {
        return this.openConnection(url, "GET", auth, accept, null);
    }

    public HttpURLConnection openHeadConnection(URL url) throws IOException {
        return this.openConnection(url, "HEAD", null, null, null);
    }

    public HttpURLConnection openPutConnection(URL url) throws IOException {
        return this.openConnection(url, "PUT", null, null, null);
    }

    private HttpURLConnection openConnection(URL url, String method, String auth, String accept, String contentType) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        if (method.equals("POST")) {
            conn.setDoOutput(true);
        }
        this.addHeaders(conn, auth, accept, contentType);
        return conn;
    }

    private void addHeaders(HttpURLConnection conn, String auth, String accept, String contentType) {
        if (contentType == null) {
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        } else {
            conn.setRequestProperty("Content-Type", contentType);
        }
        if (accept == null) {
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        } else {
            conn.setRequestProperty("Accept", accept);
        }
        if (auth != null) {
            conn.setRequestProperty("Authorization", auth);
        }
    }

    public void writeValue(HttpURLConnection connection, Object value) throws IOException {
        connection.setDoOutput(true);
        try (OutputStream stream = connection.getOutputStream();){
            mapper.writeValue(stream, value);
        }
        catch (IOException e) {
            connection.disconnect();
            throw e;
        }
    }

    public <T> T readResult(HttpURLConnection conn, Class<T> resultClass) throws IOException {
        try {
            InputStream in = conn.getInputStream();
            byte[] b = ByteStreams.toByteArray((InputStream)in);
            if (b.length == 0) {
                T t = null;
                return t;
            }
            Object object = mapper.readValue(b, resultClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new IOException(this.readError(conn), e);
        }
        finally {
            conn.disconnect();
        }
    }

    public String readResult(HttpURLConnection conn) throws IOException {
        try {
            InputStream in = conn.getInputStream();
            String string = IOUtils.toString((InputStream)in, (String)StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            throw new IOException(this.readError(conn), e);
        }
        finally {
            conn.disconnect();
        }
    }

    public JsonNode readJsonResult(HttpURLConnection conn) throws IOException {
        try {
            JsonNode jsonNode = mapper.readTree(conn.getInputStream());
            return jsonNode;
        }
        catch (IOException e) {
            throw new IOException(this.readError(conn), e);
        }
        finally {
            conn.disconnect();
        }
    }

    public <T> T readResult(HttpURLConnection conn, Class<T> resultClass, T httpErrorCodeInstance, int ... allowedStatusCodes) throws IOException {
        try {
            Object object = mapper.readValue(conn.getInputStream(), resultClass);
            return (T)object;
        }
        catch (IOException e) {
            int code = conn.getResponseCode();
            if (allowedStatusCodes != null && Ints.contains((int[])allowedStatusCodes, (int)code)) {
                T t = httpErrorCodeInstance;
                return t;
            }
            throw new IOException(this.readError(conn), e);
        }
        finally {
            conn.disconnect();
        }
    }

    private String readError(HttpURLConnection conn) {
        try {
            InputStream in = conn.getErrorStream();
            byte[] b = ByteStreams.toByteArray((InputStream)in);
            return new String(b, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

