/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.alias;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=Serializer.class)
public class AliasItem {
    private OperationType operationName = OperationType.remove;
    private String index = "";
    private String alias = "*";

    public AliasItem() {
    }

    public AliasItem(OperationType operationName, String index, String alias) {
        this.operationName = operationName;
        this.index = index;
        this.alias = alias;
    }

    public OperationType getOperationName() {
        return this.operationName;
    }

    public void setOperationName(OperationType operationName) {
        this.operationName = operationName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @JsonIgnore
    public static AliasItem getDeleteAllAliasesItem(String indexName, String pattern) {
        return new AliasItem(OperationType.remove, indexName, pattern);
    }

    @JsonIgnore
    public static AliasItem getAddAliasesItem(String indexName, String newAlias) {
        return new AliasItem(OperationType.add, indexName, newAlias);
    }

    public static class Serializer
    extends JsonSerializer<AliasItem> {
        public void serialize(AliasItem ai, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(ai.getOperationName().name());
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("index", (Object)ai.getIndex());
            jsonGenerator.writeObjectField("alias", (Object)ai.getAlias());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }

    public static enum OperationType {
        remove,
        add;

    }
}

