/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.alias;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kz.arta.util.index.conf.ElasticConfiguration;
import kz.arta.util.index.elastic.HttpBasicOperation;
import kz.arta.util.index.elastic.IndexOperationResult;
import kz.arta.util.index.elastic.alias.AliasItem;
import kz.arta.util.index.elastic.alias.AliasItems;

public class AliasOperation
extends HttpBasicOperation {
    private static final Map<String, String> indexAliases = new HashMap<String, String>();
    private AliasItems aliases = new AliasItems();
    private Map<String, String> added = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(String indexName, String alias, String removeAliasPattern) {
        Map<String, String> map = indexAliases;
        synchronized (map) {
            if (indexAliases.containsKey(indexName) && alias.equals(indexAliases.get(indexName))) {
                return;
            }
        }
        if (this.added.containsKey(indexName)) {
            return;
        }
        this.added.put(indexName, alias);
        this.aliases.addRemoveAllItem(indexName, removeAliasPattern);
        this.aliases.addAlias(AliasItem.getAddAliasesItem(indexName, alias));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexOperationResult perform() throws IOException {
        if (this.aliases.getAliases().isEmpty()) {
            return new IndexOperationResult(true, true);
        }
        HttpURLConnection connection = this.openPostConnection(this.getAliasUrl());
        this.writeValue(connection, this.aliases);
        IndexOperationResult result = this.readResult(connection, IndexOperationResult.class);
        if (result.isAcknowledged()) {
            Map<String, String> map = indexAliases;
            synchronized (map) {
                indexAliases.putAll(this.added);
            }
        }
        return result;
    }

    private URL getAliasUrl() throws MalformedURLException {
        return new URL(ElasticConfiguration.getInstance().getUrl() + "_aliases");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAliasCache() {
        Map<String, String> map = indexAliases;
        synchronized (map) {
            indexAliases.clear();
        }
    }
}

