/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.index;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import kz.arta.util.index.conf.ElasticConfiguration;
import kz.arta.util.index.elastic.HttpBasicOperation;
import kz.arta.util.index.elastic.bulk.BulkIndex;

public class IndexOperation
extends HttpBasicOperation {
    public BulkIndex index(BulkIndex index, Map<String, Object> fields) throws IOException {
        HttpURLConnection connection = this.openPutConnection(this.getIndexURL(index.getIndex(), index.getType(), index.getId()));
        this.writeValue(connection, fields);
        return this.readResult(connection, BulkIndex.class);
    }

    public BulkIndex update(BulkIndex index, Map<String, Object> fields) throws IOException {
        HttpURLConnection connection = this.openPostConnection(this.getUpdateURL(index.getIndex(), index.getType(), index.getId()));
        this.writeValue(connection, fields);
        return this.readResult(connection, BulkIndex.class);
    }

    private URL getIndexURL(String indexName, String typeName, String identifier) throws MalformedURLException {
        return new URL(ElasticConfiguration.getInstance().getUrl() + indexName + "/" + typeName + "/" + identifier);
    }

    private URL getUpdateURL(String indexName, String typeName, String identifier) throws MalformedURLException {
        return new URL(ElasticConfiguration.getInstance().getUrl() + indexName + "/" + typeName + "/" + identifier + "/_update");
    }
}

