/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.search;

import java.io.IOException;
import kz.arta.util.index.elastic.search.ElasticQuery;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=Serializer.class)
public class ElasticRangeQuery
implements ElasticQuery {
    private String field;
    private Object min;
    private Object max;
    private boolean minInclusive;
    private boolean maxInclusive;

    public ElasticRangeQuery() {
    }

    public ElasticRangeQuery(String field, Object min, Object max, boolean minInclusive, boolean maxInclusive) {
        this.field = field;
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Object getMin() {
        return this.min;
    }

    public void setMin(Object min) {
        this.min = min;
    }

    public Object getMax() {
        return this.max;
    }

    public void setMax(Object max) {
        this.max = max;
    }

    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    public static class Serializer
    extends JsonSerializer<ElasticRangeQuery> {
        public void serialize(ElasticRangeQuery property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("range");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(property.getField());
            jsonGenerator.writeStartObject();
            if (property.isMinInclusive()) {
                jsonGenerator.writeObjectField("gte", property.getMin());
            } else {
                jsonGenerator.writeObjectField("gt", property.getMin());
            }
            if (property.isMaxInclusive()) {
                jsonGenerator.writeObjectField("lte", property.getMax());
            } else {
                jsonGenerator.writeObjectField("lt", property.getMax());
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }
}

