/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kz.arta.util.index.elastic.search.ElasticProperty;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=Serializer.class)
public class IndexMapping {
    private List<DynamicTemplateItem> mappings = new ArrayList<DynamicTemplateItem>();
    private Map<String, Object> settings = new HashMap<String, Object>();
    private String typeName = "";

    public List<DynamicTemplateItem> getMappings() {
        return this.mappings;
    }

    public void addSetting(String name, Object value) {
        this.settings.put(name, value);
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public static class Serializer
    extends JsonSerializer<IndexMapping> {
        public void serialize(IndexMapping q, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(q.getTypeName());
            jsonGenerator.writeStartObject();
            for (String name : q.getSettings().keySet()) {
                jsonGenerator.writeObjectField(name, q.getSettings().get(name));
            }
            jsonGenerator.writeFieldName("dynamic_templates");
            jsonGenerator.writeStartArray();
            for (DynamicTemplateItem item : q.getMappings()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField(item.getFieldName(), (Object)item);
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }

    public static class DynamicTemplateItem {
        @JsonIgnore
        private String fieldName;
        @JsonProperty(value="match")
        private String match;
        @JsonProperty(value="mapping")
        private Map<String, Object> mapping = new HashMap<String, Object>();
        @JsonIgnore
        private Map<String, Object> properties = new HashMap<String, Object>();

        public DynamicTemplateItem() {
        }

        public DynamicTemplateItem(String fieldName, String match) {
            this.fieldName = fieldName;
            this.match = match;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getMatch() {
            return this.match;
        }

        public void setMatch(String match) {
            this.match = match;
        }

        public DynamicTemplateItem(Map<String, Object> mapping) {
            this.mapping = mapping;
        }

        public DynamicTemplateItem addMapping(String key, String value) {
            this.mapping.put(key, value);
            return this;
        }

        public DynamicTemplateItem addMapping(String key, Object value) {
            this.mapping.put(key, value);
            return this;
        }

        public DynamicTemplateItem addKeywordProperty(String name) {
            return this.addProperty(name, "keyword");
        }

        public DynamicTemplateItem addProperty(String name, String type) {
            if (!this.mapping.containsKey("properties")) {
                this.mapping.put("properties", this.properties);
            }
            this.properties.put(name, new ElasticProperty("type", type));
            return this;
        }

        public DynamicTemplateItem addTypeLong() {
            return this.addType("long");
        }

        public DynamicTemplateItem addTypeKeyword() {
            return this.addType("keyword");
        }

        public DynamicTemplateItem addTypeText() {
            return this.addType("text");
        }

        public DynamicTemplateItem addTypeNested() {
            return this.addType("nested");
        }

        public DynamicTemplateItem addTypeDate() {
            return this.addType("date");
        }

        public DynamicTemplateItem addTypeDouble() {
            return this.addType("double");
        }

        public DynamicTemplateItem addTypeBoolean() {
            return this.addType("boolean");
        }

        public DynamicTemplateItem addType(String type) {
            return this.addMapping("type", type);
        }

        public DynamicTemplateItem addIgnoreMalformed() {
            return this.addMapping("ignore_malformed", "true");
        }

        public DynamicTemplateItem addWSAnalyzer() {
            return this.addAnalyzer("whitespace");
        }

        public DynamicTemplateItem addRUAnalyzer() {
            return this.addAnalyzer("russian");
        }

        public DynamicTemplateItem addStandardDateFormat() {
            return this.addMapping("format", "yyyy-MM-dd HH:mm:ss");
        }

        public DynamicTemplateItem addBoost(float boost) {
            return this.addMapping("boost", Float.valueOf(boost));
        }

        public DynamicTemplateItem addAnalyzer(String analyzer) {
            return this.addMapping("analyzer", analyzer);
        }
    }

    public static class Type {
        public static final String TEXT = "text";
        public static final String KEYWORD = "keyword";
        public static final String BOOLEAN = "boolean";
        public static final String LONG = "long";
        public static final String DATE = "date";
        public static final String DOUBLE = "double";
        public static final String NESTED = "nested";
    }

    public static class Analyzer {
        public static final String WHITESPACE = "whitespace";
        public static final String RUSSIAN = "russian";
    }

    public static class MappingType {
        public static final String TYPE = "type";
        public static final String ANALYZER = "analyzer";
        public static final String BOOST = "boost";
        public static final String FORMAT = "format";
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }
}

