/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.config;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kz.arta.synergy.datasource.config.APIConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class APIConfigurationReader {
    public ArrayList<APIConfiguration> getConfigurations(String filePath) {
        final ArrayList<APIConfiguration> configurations = new ArrayList<APIConfiguration>();
        try {
            FileInputStream fin = new FileInputStream(filePath);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)fin, new DefaultHandler(){
                APIConfiguration currentConfiguration = null;
                String currentName = null;
                String currentValue = null;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals("listener")) {
                        this.currentConfiguration = new APIConfiguration();
                        configurations.add(this.currentConfiguration);
                    }
                    this.currentName = qName;
                    this.currentValue = "";
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.currentName.equals("event") || this.currentName.equals("queue")) {
                        this.currentValue = this.currentValue + new String(ch, start, length);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals("queue")) {
                        this.currentConfiguration.setQueueName(this.currentValue);
                    } else if (qName.equals("event")) {
                        this.currentConfiguration.setEventsClass(this.currentValue);
                    }
                }
            });
            fin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configurations;
    }
}

