/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.config;

public class ByteBuffer {
    private byte[] bytes;
    private int currentSize = 0;

    public ByteBuffer(int maxCapacity) {
        this.bytes = new byte[maxCapacity];
    }

    public void append(byte[] b, int size) {
        System.arraycopy(b, 0, this.bytes, this.currentSize, size);
        this.currentSize += size;
    }

    public void delete(int off, int len) {
        for (int i = off + len; i < this.currentSize; ++i) {
            this.bytes[i - len] = this.bytes[i];
        }
        this.currentSize -= len;
    }

    public void clear() {
        this.currentSize = 0;
    }

    public byte[] get(int off, int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.bytes, off, b, 0, len);
        return b;
    }

    public int getSize() {
        return this.currentSize;
    }

    public int indexOf(byte[] b) {
        int i = 0;
        block0: while (i < this.currentSize) {
            if (this.bytes[i] == b[0]) {
                for (int j = 1; j < b.length; ++j) {
                    if (this.bytes[i + j] == b[j]) continue;
                    ++i;
                    continue block0;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int endsWith(byte[] b) {
        int result = -1;
        block0: for (int i = 1; i <= b.length; ++i) {
            if (i >= this.currentSize) continue;
            for (int j = 0; j < i; ++j) {
                if (this.bytes[this.currentSize - i + j] != b[j]) continue block0;
            }
            result = this.currentSize - i;
        }
        return result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.currentSize; ++i) {
            str.append(this.bytes[i]).append(" ");
        }
        return str.toString();
    }
}

