/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kz.arta.synergy.datasource.config.APIConfiguration;
import kz.arta.synergy.datasource.config.APIConfigurationReader;
import kz.arta.synergy.datasource.config.ByteBuffer;
import kz.arta.synergy.datasource.config.ConfigManagerFields;
import kz.arta.synergy.datasource.config.DocEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager
extends ConfigManagerFields {
    private static final String STORAGE_SCHEMA_PROP = "storage_schema";
    private static final String SYNERGY_SCHEMA_PROP = "schema";
    private static Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);

    public static void initialize() {
        ConfigManager.initDocExents();
        ConfigManagerFields.EAR_NAME = ConfigManager.getEarName();
        ConfigManager.getLoginWarName();
        LOGGER.debug("Loaded ear name " + ConfigManagerFields.EAR_NAME);
        Properties sysProps = System.getProperties();
        LOGGER.info(sysProps.getProperty("jboss.bind.address"));
        if (sysProps.containsKey("jboss.bind.address")) {
            ConfigManagerFields.bindAddress = sysProps.getProperty("jboss.bind.address");
            LOGGER.info("Setting bind address to " + ConfigManagerFields.bindAddress);
        } else if (sysProps.containsKey("bind.address")) {
            ConfigManagerFields.bindAddress = sysProps.getProperty("bind.address");
            LOGGER.info("Setting bind address to " + ConfigManagerFields.bindAddress);
        } else {
            LOGGER.info("No jboss.bind.address or bind.address in system properties, going to use localhost");
        }
        ConfigManagerFields.fileUploadTempDir = System.getProperty("jboss.server.temp.dir") + File.separator + "Synergy" + File.separator + "upload.tmp";
        File uploadTmpFile = new File(ConfigManagerFields.fileUploadTempDir);
        if (!uploadTmpFile.exists()) {
            try {
                uploadTmpFile.mkdirs();
            }
            catch (Exception exc) {
                LOGGER.error(exc.getMessage(), (Throwable)exc);
                LOGGER.error("Failed to create temporary directory for uploading files while creating works.  Please, create dir " + ConfigManagerFields.fileUploadTempDir + " and make it writable ");
            }
        } else if (!uploadTmpFile.isDirectory() || !uploadTmpFile.canWrite()) {
            LOGGER.error(ConfigManagerFields.fileUploadTempDir + " Should be writable directory, please, fix it");
        }
        String cfgFolder = ConfigManager.getCfgURL();
        LOGGER.info("JBoss cfg directory is " + cfgFolder + ". Trying read settings from it");
        try {
            File file = new File(ConfigManager.getConfFilePath("arta/management/db.properties"));
            if (file.exists()) {
                ConfigManagerFields.props = new Properties();
                FileInputStream fis = new FileInputStream(file);
                ConfigManagerFields.props.load(fis);
                fis.close();
            } else {
                ConfigManagerFields.props = null;
                LOGGER.debug("File " + file.getAbsolutePath() + " does not exist!");
            }
            if (ConfigManagerFields.props != null && ConfigManagerFields.props.containsKey("jbpmdb")) {
                ConfigManagerFields.jbpm = ConfigManagerFields.props.get("jbpmdb") + "";
            }
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            ConfigManagerFields.props = null;
            LOGGER.error("Failed to read settings from " + cfgFolder);
        }
        LOGGER.info("JBPM schema is `" + ConfigManagerFields.jbpm + "`");
        try {
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            File file = new File(System.getProperty("jboss.home.dir") + "/lib/jboss-system.jar");
            if (file.exists()) {
                InputStream in = new ZipFile(file).getInputStream(zipEntry);
                byte[] temp = new byte[1024];
                int read = -1;
                ByteBuffer buffer = new ByteBuffer(in.available());
                while ((read = in.read(temp, 0, temp.length)) != -1) {
                    buffer.append(temp, read);
                }
                String str = new String(buffer.get(0, buffer.getSize()));
                LOGGER.info(str);
                if (str.indexOf("Specification-Version: 4.") != -1) {
                    ConfigManagerFields.JBOSS_VERSION = 4;
                }
            } else if (System.getProperty("jboss.modules.dir") != null) {
                ConfigManagerFields.JBOSS_VERSION = 7;
            }
            LOGGER.debug("Jboss version " + ConfigManagerFields.JBOSS_VERSION);
            if (ConfigManagerFields.EAR_NAME != null && ConfigManagerFields.EAR_NAME.length() > 0) {
                LOGGER.debug("Going to read jcr mapped resource name");
                String baseDir = System.getProperty("jboss.server.base.dir");
                File synergyEjbFolder = new File(baseDir + File.separator + "deployments" + File.separator + ConfigManagerFields.EAR_NAME + ".ear", "synergy-ejb.jar");
                if (synergyEjbFolder.exists()) {
                    File ejbJarFile = new File(synergyEjbFolder, "META-INF" + File.separator + "ejb-jar.xml");
                    if (ejbJarFile.exists()) {
                        FileInputStream fin = new FileInputStream(ejbJarFile);
                        byte[] b = new byte[fin.available()];
                        fin.read(b);
                        String str = new String(b);
                        Pattern p = Pattern.compile("(?:java:jboss/resource-adapters/)([A-Za-z0-9_-[.]]+)(/jcr)");
                        Matcher m = p.matcher(str);
                        if (m.find()) {
                            ConfigManagerFields.JCR_MAPPED_RESOURCE = "java:jboss/resource-adapters/" + m.group(1) + "/jcr";
                            LOGGER.debug("JCR mapped resource name is jcr/local");
                        } else {
                            LOGGER.error("Failed to read jcr mapped resource name:  parse failed ");
                        }
                    } else {
                        LOGGER.error("Failed to read jcr mapped resource name: " + ejbJarFile.getAbsolutePath() + " " + " does not exist");
                    }
                } else {
                    LOGGER.error("Failed to read jcr mapped resource name: " + synergyEjbFolder.getAbsolutePath() + " " + " does not exist");
                }
            }
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
        }
        try {
            ConfigManagerFields.configurations = new APIConfigurationReader().getConfigurations(ConfigManager.getConfFilePath("arta/api-observation-configuration.xml"));
            if (ConfigManagerFields.configurations.size() == 0) {
                LOGGER.debug("No api observers configurated");
            } else {
                LOGGER.debug(ConfigManagerFields.configurations.size() + " api observers configurated");
                for (APIConfiguration configuration : ConfigManagerFields.configurations) {
                    LOGGER.debug("API observer [event: " + configuration.getEventsClass() + ", queue: " + configuration.getQueueName() + "]");
                }
            }
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
        }
    }

    private static void initDocExents() {
        String docQueue = "java:jboss/exported/jms/queue/DocIndex";
        HashSet<String> queue = new HashSet<String>();
        queue.add("java:jboss/exported/jms/queue/DocIndex");
        ConfigManagerFields.configsCacheMap.put(DocEvent.DOC_CREATE.getEventName(), queue);
        ConfigManagerFields.configsCacheMap.put(DocEvent.DOC_REMOVE.getEventName(), queue);
        ConfigManagerFields.configsCacheMap.put(DocEvent.DOC_UPDATE.getEventName(), queue);
        ConfigManagerFields.configsCacheMap.put(DocEvent.DOC_CARD_UPDATE.getEventName(), queue);
    }

    public static String getEarName() {
        String classLoader = Thread.currentThread().getContextClassLoader().toString();
        Pattern p = Pattern.compile("(?:deployment.)([A-Za-z0-9_-[.]]+)(.ear)");
        Matcher m = p.matcher(classLoader);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static void getLoginWarName() {
        String property = System.getProperty("jboss.home.dir");
        if (property == null) {
            return;
        }
        File homeDir = new File(property);
        File loginWarFile = new File(homeDir, "standalone/deployments/login.war");
        if (loginWarFile.exists()) {
            ConfigManagerFields.LOGIN_WAR = "/login";
        }
    }

    public static String getCfgURL() {
        String cfgDir = System.getProperty("jboss.server.config.url");
        if (cfgDir == null) {
            cfgDir = System.getProperty("jboss.server.config.dir");
            cfgDir = cfgDir != null ? "file://" + cfgDir : "file:///home/topa/services/jboss/server/default/conf";
        }
        return cfgDir;
    }

    public static String getCfgDirectory() {
        String cfgDir = System.getProperty("jboss.server.config.url");
        if (cfgDir != null && cfgDir.startsWith("file://")) {
            try {
                URL url = new URL(cfgDir);
                return url.getFile();
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (cfgDir == null) {
            cfgDir = System.getProperty("jboss.server.config.dir");
            if (cfgDir != null) {
                return cfgDir;
            }
            return "/home/topa/services/jboss/server/default/conf";
        }
        return cfgDir;
    }

    private static Properties getConfProps() {
        Properties properties = new Properties();
        try {
            File file = new File(ConfigManager.getConfFilePath("/arta/management/db.properties"));
            if (file.exists()) {
                LOGGER.debug("Reading settings from " + file.getAbsolutePath());
                properties.load(new FileInputStream(file));
            } else {
                properties = null;
                LOGGER.debug("File " + file.getAbsolutePath() + " does not exist!");
            }
        }
        catch (Exception exc) {
            properties = null;
            LOGGER.error(exc.getMessage(), (Throwable)exc);
        }
        return properties;
    }

    public static Properties getAPIConfProps() {
        Properties properties = new Properties();
        try {
            File file = new File(ConfigManager.getConfFilePath("/arta/api.properties"));
            if (file.exists()) {
                LOGGER.debug("Reading settings from " + file.getAbsolutePath());
                properties.load(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            } else {
                properties = null;
                LOGGER.debug("File " + file.getAbsolutePath() + " does not exist!");
            }
        }
        catch (Exception exc) {
            properties = null;
            LOGGER.error(exc.getMessage(), (Throwable)exc);
        }
        return properties;
    }

    public static Properties getDBSettings() {
        Properties prop = ConfigManager.getConfProps();
        if (prop != null) {
            if (prop.getProperty(SYNERGY_SCHEMA_PROP) == null) {
                prop.put(SYNERGY_SCHEMA_PROP, "synergy");
                LOGGER.info("Setting schema to `synergy`");
            }
            if (prop.getProperty(STORAGE_SCHEMA_PROP) == null) {
                prop.put(STORAGE_SCHEMA_PROP, "storage");
            }
        }
        return prop;
    }

    public static String getSynergySchema() {
        Properties properties = ConfigManager.getDBSettings();
        return properties != null ? properties.getProperty(SYNERGY_SCHEMA_PROP) : "synergy";
    }

    public static String getStorageSchema() {
        Properties properties = ConfigManager.getDBSettings();
        return properties != null ? properties.getProperty(STORAGE_SCHEMA_PROP) : "storage";
    }

    public static boolean needImagesCashing() {
        Properties prop = ConfigManager.getConfProps();
        return prop != null && prop.get("image_cache") != null && prop.get("image_cache").equals("true");
    }

    public static boolean needScriptCashing() {
        Properties prop = ConfigManager.getConfProps();
        return prop != null && prop.get("script_cache") != null && prop.get("script_cache").equals("true");
    }

    public static String getJcrResourceName() {
        return ConfigManagerFields.JCR_MAPPED_RESOURCE;
    }

    public static String getSynergyDS() {
        if (ConfigManagerFields.EAR_NAME.equals("Synergy")) {
            return "java:/SynergyDS";
        }
        return "java:jboss/datasources/" + ConfigManagerFields.EAR_NAME + "/synergy";
    }

    public static String getSynergyDSNonXA() {
        if (ConfigManagerFields.EAR_NAME.equals("Synergy")) {
            return "java:/AMDS";
        }
        return "java:jboss/datasources/" + ConfigManagerFields.EAR_NAME + "/AMDS";
    }

    public static String getQueueName(String simpleQueueName) {
        if (ConfigManagerFields.EAR_NAME.equals("Synergy")) {
            return "java:/queue/" + simpleQueueName;
        }
        return "java:jboss/queues/" + ConfigManagerFields.EAR_NAME + "/" + simpleQueueName;
    }

    public static String getConfFileURL(String relativePath) {
        if (ConfigManagerFields.EAR_NAME == null || ConfigManagerFields.EAR_NAME.equals("Synergy")) {
            return ConfigManager.getCfgURL() + "/" + relativePath;
        }
        return ConfigManager.getCfgURL() + "/" + ConfigManagerFields.EAR_NAME + "/" + relativePath;
    }

    public static String getConfFilePath(String relativePath) {
        if (ConfigManagerFields.EAR_NAME == null || ConfigManagerFields.EAR_NAME.equals("Synergy")) {
            return ConfigManager.getCfgDirectory() + "/" + relativePath;
        }
        return ConfigManager.getCfgDirectory() + "/" + ConfigManagerFields.EAR_NAME + "/" + relativePath;
    }

    public static String getProcessEngineJNDI() {
        if (ConfigManagerFields.EAR_NAME == null || ConfigManagerFields.EAR_NAME.equals("Synergy")) {
            return "java:/ProcessEngine";
        }
        return "java:/" + ConfigManagerFields.EAR_NAME + "/ProcessEngine";
    }

    public static Collection<String> getQueuesForEvent(String event) {
        if (ConfigManagerFields.configsCacheMap.containsKey(event)) {
            return ConfigManagerFields.configsCacheMap.get(event);
        }
        ArrayList<String> queues = new ArrayList<String>();
        for (APIConfiguration configuration : ConfigManagerFields.configurations) {
            if (!configuration.supportEvent(event)) continue;
            queues.add(configuration.getQueueName());
        }
        ConfigManagerFields.configsCacheMap.put(event, queues);
        return queues;
    }

    static {
        ConfigManager.initialize();
    }
}

