/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.mysql;

import java.sql.Connection;
import kz.arta.synergy.datasource.mysql.ArtaMysqlConfigDefaultFields;
import kz.arta.synergy.datasource.mysql.ArtaMysqlConfigManager;
import kz.arta.synergy.datasource.mysql.DataExtractorCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtaMysqlCheckConnThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtaMysqlCheckConnThread.class);
    private StackTraceElement[] elements;
    private Connection con = null;
    private static boolean isEnabled = false;
    private static long timeout = 0L;
    private static boolean closeConnections = false;

    private ArtaMysqlCheckConnThread(StackTraceElement[] elements, Connection con) {
        this.elements = elements;
        this.con = con;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.con != null && !this.con.isClosed()) {
                StringBuilder str = new StringBuilder();
                for (StackTraceElement element : this.elements) {
                    str.append("\n\t");
                    str.append(element.toString());
                }
                LOGGER.error("Connection was not closed within allowed timeout [" + timeout + "] !" + str.toString());
                if (closeConnections) {
                    LOGGER.error("Closing connection for you");
                    try {
                        this.con.close();
                    }
                    catch (Exception exc) {
                        LOGGER.error(exc.getMessage(), (Throwable)exc);
                    }
                }
            }
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
        }
    }

    public static void startObserveConnection(Connection con, StackTraceElement[] elements) {
        if (!isEnabled) {
            return;
        }
        new ArtaMysqlCheckConnThread(elements, con).start();
    }

    static {
        if (ArtaMysqlConfigManager.props.containsKey(ArtaMysqlConfigDefaultFields.ConfigKeyProperties.observe_connections.name()) && DataExtractorCommon.getBoolean(ArtaMysqlConfigManager.props.get(ArtaMysqlConfigDefaultFields.ConfigKeyProperties.observe_connections.name())).booleanValue()) {
            isEnabled = true;
            timeout = DataExtractorCommon.getLongStat(ArtaMysqlConfigManager.props.get(ArtaMysqlConfigDefaultFields.ConfigKeyProperties.observe_connection_timeout.name()));
            closeConnections = DataExtractorCommon.getBoolean(ArtaMysqlConfigManager.props.get(ArtaMysqlConfigDefaultFields.ConfigKeyProperties.close_observing_connection.name()));
            if (timeout < 180000L) {
                timeout = 180000L;
            }
        }
        LOGGER.info("Observing opened connections is " + (isEnabled ? "enabled" : "disabled"));
        if (isEnabled) {
            LOGGER.info("Started observing connections with parameters: timeout=" + timeout + "ms; close_connections=" + closeConnections);
            if (closeConnections) {
                LOGGER.error("WARNING! Closing connections in production mode is a VERY BAD IDEA. If you really need to do this contact developers.");
            }
        }
    }
}

