/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.mysql;

import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import kz.arta.synergy.datasource.mysql.ArtaMysqlCheckConnThread;
import kz.arta.synergy.datasource.mysql.ArtaMysqlConfigManager;
import kz.arta.synergy.datasource.mysql.ConnectionImpl;
import kz.arta.synergy.datasource.utils.CloserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtaMysqlConnectionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtaMysqlConnectionPool.class);

    public static Connection getXAConnection() {
        Connection con = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(ArtaMysqlConfigManager.getSynergyDS());
            con = ds.getConnection();
            ArtaMysqlCheckConnThread.startObserveConnection(con, Thread.currentThread().getStackTrace());
            return new ConnectionImpl(con);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ArtaMysqlConnectionPool.closeConnection(con);
            throw new IllegalStateException(e);
        }
    }

    public static Connection getDefaultXAConnection() {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:/SynergyDS");
            Connection con = ds.getConnection();
            ArtaMysqlCheckConnThread.startObserveConnection(con, Thread.currentThread().getStackTrace());
            return new ConnectionImpl(con);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void closeConnection(Connection con) {
        CloserUtil.close(con);
    }
}

