/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.updateDB;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import kz.arta.synergy.datasource.mysql.ArtaMysqlConnectionPool;
import kz.arta.synergy.datasource.updateDB.UpdateIf;
import kz.arta.synergy.datasource.updateDB.UpdateLog;
import kz.arta.synergy.datasource.updateDB.config.UpdateConfiguration;
import kz.arta.synergy.datasource.updateDB.config.UpdateEntry;

public class UpdateManager {
    public static final String UPDATE_ROOT_CONFIG = "UpdateConfiguration.xml";
    public static String updateRootFolder = "kz/arta/synergy/db/updates";
    public static String updateRootPackage = "kz.arta.synergy.db.updates";

    public static List<UpdateEntry> getAwaitingUpdates() throws SQLException, JAXBException {
        try (Connection con = ArtaMysqlConnectionPool.getXAConnection();){
            List<UpdateEntry> list = UpdateManager.getAwaitingUpdates(con);
            return list;
        }
    }

    private static List<UpdateEntry> getAwaitingUpdates(Connection con) throws SQLException, JAXBException {
        List<UpdateEntry> entries = UpdateManager.getAllUpdates();
        ArrayList<UpdateEntry> awaitingEntries = new ArrayList<UpdateEntry>();
        Set<UpdateEntry> executedUpdates = UpdateManager.getExecutedUpdates(con);
        for (UpdateEntry entry : entries) {
            if (executedUpdates.contains(entry)) continue;
            awaitingEntries.add(entry);
        }
        return awaitingEntries;
    }

    public static void executeUpdates(UpdateLog log) throws Exception {
        List<UpdateEntry> sets = UpdateManager.getAwaitingUpdates();
        for (UpdateEntry updateEntry : sets) {
            UpdateManager.executeUpdate(updateEntry, log);
            log.printComment("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435: " + updateEntry.getId() + " - " + updateEntry.getComment() + "");
        }
    }

    private static void executeUpdate(UpdateEntry update, UpdateLog log) throws Exception {
        try (Connection con = ArtaMysqlConnectionPool.getXAConnection();){
            String className = updateRootPackage + "." + update.getClassName();
            ClassLoader loader = UpdateManager.class.getClassLoader();
            Class<?> updateClass = loader.loadClass(className);
            UpdateIf updateImpl = (UpdateIf)updateClass.newInstance();
            updateImpl.execute(con, log);
            PreparedStatement addVersionChangeSt = con.prepareStatement("INSERT INTO db_changes(updateId, className, updateComment, created) VALUES (?, ?, ?, now()) ");
            addVersionChangeSt.setString(1, update.getId());
            addVersionChangeSt.setString(2, update.getClassName());
            addVersionChangeSt.setString(3, update.getComment());
            addVersionChangeSt.execute();
        }
    }

    private static Set<UpdateEntry> getExecutedUpdates() throws SQLException {
        try (Connection con = ArtaMysqlConnectionPool.getXAConnection();){
            Set<UpdateEntry> set = UpdateManager.getExecutedUpdates(con);
            return set;
        }
    }

    private static Set<UpdateEntry> getExecutedUpdates(Connection con) throws SQLException {
        HashSet<UpdateEntry> updates = new HashSet<UpdateEntry>();
        PreparedStatement checkDB = con.prepareStatement("SHOW TABLES LIKE 'db_changes'");
        if (!checkDB.executeQuery().next()) {
            return updates;
        }
        PreparedStatement getUpdateList = con.prepareStatement("SELECT updateId, className, updateComment FROM db_changes ORDER BY id ");
        ResultSet res = getUpdateList.executeQuery();
        while (res.next()) {
            updates.add(new UpdateEntry(res.getString("updateId"), res.getString("className"), res.getString("updateComment")));
        }
        return updates;
    }

    public static List<UpdateEntry> getAllUpdates() throws JAXBException {
        UpdateConfiguration conf = UpdateConfiguration.getInstance(updateRootFolder + "/" + UPDATE_ROOT_CONFIG);
        return conf.getUpdateEntries();
    }
}

