package queue.listeners;

import kz.arta.synergy.forms.common.util.JsonUtil;
import operation.UnblockOperation;
import operation.dbutils.ConnectionPool;
import operation.dbutils.ConnectionPoolImpl;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.JsonNode;
import queue.services.DeleteService;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

@MessageDriven(name = "DeleteTask", activationConfig = {
        @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/DeleteTask"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge") })
public class DeleteTaskListener implements MessageListener {

    @Override
    public void onMessage(Message message) {
        String documentID = "";
        String executionID = "";
        try {
            JsonNode node = JsonUtil.readTree(((TextMessage) message).getText());
            documentID = node.get("documentID").asText();
            executionID = node.get("executionID").asText();
            DeleteService.delete(documentID);
            UnblockOperation unblockOperation = new UnblockOperation("http://127.0.0.1:8080/Synergy", "Basic " + Base64.encodeBase64String(("admincrm" + ":" + "Adm1nCRM").getBytes()));
            unblockOperation.unblock(executionID, "Ok", "got_agree");
        } catch (Exception e) {
            System.out.println("DeleteTask was not completed for documentId " + documentID + " with error");
            System.out.println(e.getMessage());
            try {
                UnblockOperation unblockOperation = new UnblockOperation("http://127.0.0.1:8080/Synergy", "Basic " + Base64.encodeBase64String(("admincrm" + ":" + "Adm1nCRM").getBytes()));
                unblockOperation.unblock(executionID, e.getMessage(), "got_agree");
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}
