package queue.services;

import operation.dbutils.ConnectionPool;
import operation.dbutils.ConnectionPoolImpl;

import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

public class DeleteService {

    private static ConnectionPool connectionPool = ConnectionPoolImpl.getInstance(20);

    public static void delete (String docId) throws Exception {
        if (Objects.isNull(docId)) {
            System.out.println("Документ не должен быть пустым");
        }
        deleteFromDb(docId);
    }

    private static void deleteFromDb(String docId) throws Exception {
        Connection conn = connectionPool.getConnection();

        try (PreparedStatement pre = conn.prepareStatement("delete from finished_work where documentId = ?")) {
            pre.setString(1, docId);
            int result = pre.executeUpdate();
            if (result == 0) {
                System.out.println("Records were not deleted");
            }
        } catch (SQLException e) {
            System.out.println("Records were not deleted" + e);
            throw e;
        } finally {
            connectionPool.returnConnection(conn);
        }
    }

}
