package queue.services;

import kz.arta.synergy.forms.common.object.ASFData;
import kz.arta.synergy.forms.common.object.ASFDataWrapperExt;
import models.ReestrModel;
import operation.NumberUtils;
import operation.dbutils.ConnectionPool;
import operation.dbutils.ConnectionPoolImpl;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;

public class InsertService {

    private static ConnectionPool connectionPool = ConnectionPoolImpl.getInstance(20);

    public static void insert(ASFDataWrapperExt data, String docId) throws Exception {
        int count = SynergyWriteDataService.rowsCountInDocument(data.getData("dynamic_table").getData());
        insert(data, docId, count);

    }

    public static void insert(ASFDataWrapperExt data, String docId, int count) throws Exception {
        insertToDb(fill(data, docId, count));
    }

    private  static List<ReestrModel> fill(ASFDataWrapperExt source, String docId, int count) {
        List<ASFData.Data> asfDataList = source.getData("dynamic_table").getData();
        String stringSate = source.getData("research_end_date").getKey();
        if (stringSate == null || stringSate.equalsIgnoreCase("")) {
            return new ArrayList<>();
        }
        Date date = Date.valueOf(stringSate.split(" ")[0]);
        String stateId = source.getData("personal_card_name_company_ru1").getKey();
        String regionId = source.getData("personal_card_name_department_ru1").getKey();
        List<ReestrModel> asfList = new ArrayList<>();
        for (int i = 1; i <= count; i++) {
            ReestrModel model = fillLevel(asfDataList, i);
            model.setDocumentID(docId);
            model.setSubLabName(source.getData("list_department").getValue());
            model.setSubLabNameCode(source.getData("list_department").getKey());
            model.setDate(date);
            model.setStateId(stateId);
            model.setRegionId(regionId);
            asfList.add(model);
        }
        return asfList;
    }

    private static ReestrModel fillLevel(List<ASFData.Data> asfList, int level) {
        if (asfList == null) return null;
        ReestrModel reestrModel = new ReestrModel();
        for (ASFData.Data com : asfList) {
            if (com.getId().equalsIgnoreCase("research_register-b" + level)) {
                reestrModel.setResName(com.getValue());
            }
            else if (com.getId().equalsIgnoreCase("lab_name-b" + level)) {
                reestrModel.setLabName(com.getValue());
                reestrModel.setLabNameCode(com.getKey());
            }
            else if (com.getId().equalsIgnoreCase("research_group-b" + level)) {
                reestrModel.setResGroup(com.getValue());
                reestrModel.setResGroupCode(com.getKey());
            }
            else if (com.getId().equalsIgnoreCase("research_subgroup-b" + level)) {
                reestrModel.setSubResGroup(com.getValue());
                reestrModel.setSubResGroupCode(com.getKey());
            }
            else if (com.getId().equalsIgnoreCase("research_method-b" + level)) {
                reestrModel.setResMethod(com.getValue());
            }
            else if (com.getId().equalsIgnoreCase("service_unit-b" + level)) {
                reestrModel.setSerUnit(com.getValue());
            }
            else if (com.getId().equalsIgnoreCase("cost_coefficient-b" + level)) {
                reestrModel.setCoeficient(com.getValue());
            }
            else if (com.getId().equalsIgnoreCase("tarificator_research_code-b" + level)) {
                reestrModel.setTarCode(com.getValue());
            }
            else if (com.getId().equalsIgnoreCase("base_rate-b" + level)) {
                reestrModel.setBaseRate(com.getValue());
            }
            else if (com.getId().equalsIgnoreCase("services_amount-b" + level)) {
                reestrModel.setSerAmount(com.getValue());
            }
            else if (com.getId().equalsIgnoreCase("mismatch_services_amount-b" + level)) {
                reestrModel.setmSerAmount(com.getValue());
            }
            else if (com.getId().equalsIgnoreCase("base_rate-b" + level)) {
                reestrModel.setBaseRate(com.getValue());
            }
        }
        return reestrModel;
    }

    private static void insertToDb(List<ReestrModel> reestrModelList) throws Exception {
        Connection conn = connectionPool.getConnection();

        try (PreparedStatement pre = conn.prepareStatement(insertSql(), Statement.RETURN_GENERATED_KEYS)) {

            System.out.println("Inserted rows for document " + reestrModelList.get(0).getDocumentID() + " = " + reestrModelList.size());

            for (ReestrModel md : reestrModelList) {
                pre.setNString(1, md.getDocumentID());
                pre.setDate(2, md.getDate());
                pre.setInt(3, NumberUtils.parseInt(md.getStateId()));
                pre.setInt(4, NumberUtils.parseInt(md.getRegionId()));
                pre.setNString(5, md.getResName());
                pre.setNString(6, md.getLabName());
                pre.setInt(7, NumberUtils.parseInt(md.getLabNameCode()));
                pre.setNString(8, md.getResGroup());
                pre.setInt(9,  NumberUtils.parseInt(md.getResGroupCode()));
                pre.setNString(10, md.getSubResGroup());
                pre.setInt(11, NumberUtils.parseInt(md.getSubResGroupCode()));
                pre.setNString(12, md.getResMethod());
                pre.setNString(13, md.getSerUnit());
                pre.setDouble(14, NumberUtils.parseDouble(md.getCoeficient()));
                pre.setNString(15, md.getTarCode());
                pre.setDouble(16, NumberUtils.parseDouble(md.getBaseRate()));
                pre.setInt(17, NumberUtils.parseInt(md.getSerAmount()));
                pre.setInt(18, NumberUtils.parseInt(md.getmSerAmount()));
                pre.setNString(19, md.getSubLabName());
                pre.setNString(20, md.getSubLabNameCode());
                int code = pre.executeUpdate();
                if (code == 0) {
                    System.out.println("Something wrong happened");
                }
                try (ResultSet generatedKeys = pre.getGeneratedKeys()) {
                    if (generatedKeys.next()) {
                        md.setDbId(generatedKeys.getString(1));
                    }
                    else {
                        throw new SQLException("Creating user failed, no ID obtained.");
                    }
                }
            }
        } catch (SQLException e) {
            System.out.println("not inserted " + e);
            throw e;
        } finally {
            connectionPool.returnConnection(conn);
        }
    }

    private static String insertSql() {
        return "INSERT INTO finished_work(documentID, dbeg, stateid, regionid, resname, labname, labcode, resgroup, resgroupCode, subresgroup, subresgroupCode, resmethod, serunit, coeficient, tarcode, base_rate, seramount, mseramount, subLabName, subLabNameCode) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }
}
