package operation.IntegrationOperation;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.forms.common.object.ASFData;
import kz.arta.synergy.forms.common.object.ASFDataWrapperExt;
import kz.arta.synergy.forms.common.util.rest.operations.AsfDataApi;
import models.jsonmodels.ExpenseModel;
import models.jsonmodels.ExpensesInnerModel;
import operation.OperationInterfaces.Service;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.*;

public class Expense implements Service {

    @Override
    public String exec(String param) throws IOException {
        System.out.println("EXPENSE ENTER");
        AsfDataApi asfDataApi = new AsfDataApi("http://test-lis.nce.kz/Synergy", "Basic " + Base64.encodeBase64String(("admincrm" + ":" + "Adm1nCRM").getBytes(StandardCharsets.ISO_8859_1)));
        ASFDataWrapperExt asfDataWrapperExt = asfDataApi.getAsfData("141752");
        System.out.println("DATA IS RECEIVED");
        ExpenseModel expenseModel = new ExpenseModel();
        String reportDate = null;
        List<ASFData.Data> dataList = asfDataWrapperExt.getData("table-a9sbti").getData();
        for (ASFData.Data d : dataList) {
            if (d.getId().equalsIgnoreCase("report_date-b1")) {
                reportDate = DateTime.parse(d.getKey(), DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toString("yyyyMMdd");
            }
        }
        expenseModel.setReportDate(Objects.isNull(reportDate) ? "" : reportDate);
        long branchWarehouse = Long.parseLong(asfDataWrapperExt.getData("branch_warehouse").getKey());
        expenseModel.setBranchWarehouse(branchWarehouse);
        long warehouse = Long.parseLong(asfDataWrapperExt.getData("warehouse").getKey());
        expenseModel.setWarehouse(warehouse);

        dataList = asfDataWrapperExt.getData("table_reagent").getData();
        List<ExpensesInnerModel> expensesInnerModels = new ArrayList<>();
        if (dataList.size() > 7) {
            String lastId = dataList.get(dataList.size() - 1).getId();
            int j = Integer.parseInt(lastId.substring(lastId.length() - 1));
            for (int i = 1; i <= j; i++) {
                ExpensesInnerModel innerModel = new ExpensesInnerModel();
                for (ASFData.Data d : dataList) {
                    if (d.getId().equalsIgnoreCase("code-b" + i)) {
                        innerModel.setCode(d.getValue());
                    }
                    if (d.getId().equalsIgnoreCase("name_reagent-b" + i )) {
                        innerModel.setNameReagent(d.getValue());
                    }
                    if (d.getId().equalsIgnoreCase("series_reagent-b" + i )) {
                        innerModel.setSeriesReagen(d.getValue());
                    }
                    if (d.getId().equalsIgnoreCase("term_reagent-b" + i )) {
                        String termDate = DateTime.parse(d.getKey(), DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toString("yyyyMMdd");
                        innerModel.setTermReagent(termDate);
                    }
                    if (d.getId().equalsIgnoreCase("unit_of_change-b" + i )) {
                        long unitOfChange = Long.parseLong(d.getKey());
                        innerModel.setUnitOfChange(unitOfChange);
                    }
                    if (d.getId().equalsIgnoreCase("research_expense-b" + i )) {
                        long research = Long.parseLong(d.getKey());
                        innerModel.setUnitOfChange(research);
                    }
                }
                expensesInnerModels.add(innerModel);
            }
        }

        expenseModel.setExpensesInnerModels(expensesInnerModels);
        return JsonUtils.toJson(expenseModel);
    }
}
