package processes;

import operation.IntegrationOperation.*;
import operation.OperationInterfaces.Service;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

@WebServlet(urlPatterns = "/merger/*")
public class MergerConnection extends HttpServlet {

    Map<String, Service> reestrs = new HashMap<String, Service>() {{
        put("reestr_informatsiya_o_raskhody", new Expense());
        put("reestr_informatsiya_o_sklade", new WareHouseInfo());
        put("reestr_oplata_dlya_fl", new FLPayment());
        put("nce_registry_consolidated_application", new ConsolidApp());
        put("nce_registry_consolidated_application_add", new AdditionalOnfo());
    }};
    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        process(httpServletRequest, httpServletResponse);
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        process(httpServletRequest, httpServletResponse);
    }

    private void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String baseUri = request.getRequestURI();
        String[] uriArray = baseUri.split("/");
        if (uriArray.length <= 1) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = request.getReader()) {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        String inOperation = uriArray[uriArray.length - 1];
        System.out.println(inOperation);
        Service methodOperation = reestrs.get(inOperation);
        System.out.println(reestrs.size());
        System.out.println(methodOperation);
        System.out.println(methodOperation);
        String res = methodOperation.exec(stringBuilder.toString());
        System.out.println(res);
        try (Writer writer = response.getWriter()) {
            writer.write(res);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
