import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.forms.common.object.ASFDataWrapperExt;
import kz.arta.synergy.forms.common.util.rest.operations.AsfDataApi;
import models.jsonmodels.ExpenseModel;
import models.jsonmodels.ExpensesInnerModel;
import operation.HttpUtils;
import operation.IntegrationOperation.Expense;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.JsonNode;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.junit.Test;
import wsdl.consolid.CRM1C;
import wsdl.consolid.CRM1CPortType;
import wsdl.consolid.TMessage;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.*;

public class DateTimeTest {
    @Test
    public void test() throws Exception {
        connectTest();
    }

    private void connectTest() throws Exception {
        AsfDataApi asfDataApi = new AsfDataApi("http://lis.nce.kz/Synergy", "Basic " + Base64.encodeBase64String(("admincrm" + ":" + "Adm1nCRM").getBytes(StandardCharsets.ISO_8859_1)));
        ASFDataWrapperExt asfDataWrapperExt = asfDataApi.getAsfData("141752");
        System.out.println(asfDataWrapperExt.getData("text_number_samples").getValue());
    }

    private void soapTest() {
        CRM1C crm1C = new CRM1C();
        CRM1CPortType crm1CPortType = crm1C.getCRM1CSoap();
        String r = crm1CPortType.putContractInfo(new TMessage());
        System.out.println(r);
    }

    private void arrayTest() {
        HashSet<BigDecimal> bigDecimals = new HashSet<>();
        bigDecimals.add(new BigDecimal("1.0"));
        bigDecimals.add(new BigDecimal("1.00"));
        System.out.println(bigDecimals.size());

        TreeSet<BigDecimal> bigDecimals1 = new TreeSet<>();
        bigDecimals1.add(new BigDecimal("1.0"));
        bigDecimals1.add(new BigDecimal("1.00"));
        System.out.println(bigDecimals1.size());
    }

    private void timeTest() {
        System.out.println(DateTime.now().toString("yyyyMMddHHmmss"));
    }

    private void docDataTest() throws Exception {
        HttpUtils utils = new HttpUtils("http://lis.arta.pro/Synergy", "Basic " + Base64.encodeBase64String(("admincrm" + ":" + "Adm1nCRM").getBytes(StandardCharsets.ISO_8859_1)));
        JsonNode node = utils.getDocData("783367c8-f2fd-4c5f-b32c-1b5747ff6a9b");
        System.out.println(node.get("createDate").asText());
        System.out.println(DateTime.parse(node.get("createDate").asText(), DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toString("yyyyMMdd"));
    }

    private void jsonTest() throws Exception {
        ExpenseModel expenseModel = new ExpenseModel();
        expenseModel.setReportDate("1125366");
        expenseModel.setWarehouse(12555);
        expenseModel.setBranchWarehouse(458966);
        List<ExpensesInnerModel> expensesInnerModels = new ArrayList<>();
        ExpensesInnerModel innerModel = new ExpensesInnerModel();
        innerModel.setCode("code");
        innerModel.setNameReagent("Reagent");
        innerModel.setResearchExpense(44558);
        innerModel.setSeriesReagen("asdas");
        innerModel.setTermReagent("Term");
        innerModel.setUnitOfChange(458);
        expensesInnerModels.add(innerModel);
        expenseModel.setExpensesInnerModels(expensesInnerModels);
        System.out.println(JsonUtils.toJson(expenseModel));
    }

    private void execTest() throws Exception {
        Expense expense = new Expense();
        System.out.println(expense.exec(""));
    }
}
