/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.buffer;

public class SimpleByteBuffer {
    private byte[] bytes;
    private int maxCapacity;
    private int currentSize = 0;

    public SimpleByteBuffer(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.bytes = new byte[maxCapacity];
    }

    public void append(byte[] b, int size) {
        for (int i = 0; i < size; ++i) {
            this.bytes[this.currentSize + i] = b[i];
        }
        this.currentSize += size;
    }

    public void delete(int off, int len) {
        for (int i = off + len; i < this.currentSize; ++i) {
            this.bytes[i - len] = this.bytes[i];
        }
        this.currentSize -= len;
    }

    public void clear() {
        this.currentSize = 0;
    }

    public byte[] get(int off, int len) {
        byte[] b = new byte[len];
        for (int i = off; i < off + len; ++i) {
            b[i - off] = this.bytes[i];
        }
        return b;
    }

    public int getSize() {
        return this.currentSize;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.currentSize; ++i) {
            str.append(this.bytes[i] + " ");
        }
        return str.toString();
    }
}

