/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic;

import java.text.SimpleDateFormat;
import java.util.Date;
import kz.arta.util.index.elastic.search.ElasticBooleanQuery;
import kz.arta.util.index.elastic.search.ElasticMatchAllDocsQuery;
import kz.arta.util.index.elastic.search.ElasticQuery;
import kz.arta.util.index.elastic.search.ElasticRangeQuery;
import kz.arta.util.index.elastic.search.ElasticTermQuery;
import kz.arta.util.index.elastic.search.ElasticWildcardQuery;
import kz.arta.util.index.utils.QueryBuilder;

public class ElasticQueryBuilder
implements QueryBuilder<ElasticQuery> {
    private QueryBuilder.QueryChainItem<ElasticBooleanQuery> root = null;
    private QueryBuilder.QueryChainItem<ElasticBooleanQuery> current = null;

    @Override
    public void openBooleanQuery(QueryBuilder.Occur occur) {
        QueryBuilder.QueryChainItem<ElasticBooleanQuery> candidate = new QueryBuilder.QueryChainItem<ElasticBooleanQuery>(this.current, new ElasticBooleanQuery(), occur);
        if (this.root == null) {
            this.root = candidate;
        }
        this.current = candidate;
    }

    @Override
    public void closeBooleanQuery() {
        QueryBuilder.QueryChainItem<ElasticBooleanQuery> parent = this.current.getParent();
        if (parent != null) {
            if (this.current.getQuery().isSingleShould()) {
                parent.getQuery().add(this.current.getQuery().getShould().get(0), this.current.getOccur());
            } else if (!this.current.getQuery().isEmpty()) {
                parent.getQuery().add(this.current.getQuery(), this.current.getOccur());
            }
        }
        this.current = this.current.getParent();
    }

    @Override
    public void addNumericRangeQuery(String fieldName, long min, long max, boolean minInclusive, boolean maxInclusive, QueryBuilder.Occur occur) {
        ElasticRangeQuery q = new ElasticRangeQuery(fieldName, min, max, minInclusive, maxInclusive);
        this.add(q, occur);
    }

    @Override
    public void addDateRangeQuery(String fieldName, Date min, Date max, boolean minInclusive, boolean maxInclusive, QueryBuilder.Occur occur) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        ElasticRangeQuery q = new ElasticRangeQuery(fieldName, format.format(min), format.format(max), minInclusive, maxInclusive);
        this.add(q, occur);
    }

    @Override
    public void addTermRangeQuery(String fieldName, String min, String max, boolean minInclusive, boolean maxInclusive, QueryBuilder.Occur occur) {
        ElasticRangeQuery q = new ElasticRangeQuery(fieldName, min, max, minInclusive, maxInclusive);
        this.add(q, occur);
    }

    @Override
    public void addTermQuery(String fieldName, String term, QueryBuilder.Occur occur) {
        ElasticTermQuery q = new ElasticTermQuery(fieldName, term);
        this.add(q, occur);
    }

    @Override
    public void addTermQuery(String fieldName, String term, float boost, QueryBuilder.Occur occur) {
        ElasticTermQuery q = new ElasticTermQuery(fieldName, term);
        q.setBoost(boost);
        this.add(q, occur);
    }

    @Override
    public void addWildcardQuery(String fieldName, String term, QueryBuilder.Occur occur) {
        ElasticWildcardQuery q = new ElasticWildcardQuery(fieldName, term);
        this.add(q, occur);
    }

    @Override
    public void addMatchAllDocsQuery() {
        this.add(new ElasticMatchAllDocsQuery(), QueryBuilder.Occur.MUST);
    }

    @Override
    public void addPhraseQuery(String fieldId, String phrase, Class analyzerClass, QueryBuilder.Occur occur) {
        ElasticTermQuery q = new ElasticTermQuery(fieldId, phrase);
        q.setPhrase(true);
        this.add(q, occur);
    }

    @Override
    public void addPhraseQuery(String fieldId, String phrase, Class analyzerClass, float boost, QueryBuilder.Occur occur) {
        ElasticTermQuery q = new ElasticTermQuery(fieldId, phrase);
        q.setPhrase(true);
        q.setBoost(boost);
        this.add(q, occur);
    }

    @Override
    public void clear() {
        this.root = null;
        this.current = null;
    }

    private void add(ElasticQuery q, QueryBuilder.Occur occur) {
        this.current.getQuery().add(q, occur);
    }

    @Override
    public ElasticQuery build() {
        return this.root.getQuery();
    }
}

