/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.bulk;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kz.arta.util.index.conf.ElasticConfiguration;
import kz.arta.util.index.elastic.HttpBasicOperation;
import kz.arta.util.index.elastic.bulk.BulkIndex;
import kz.arta.util.index.elastic.bulk.BulkResult;

public class BulkIndexOperation
extends HttpBasicOperation {
    public static final long MAX_BULK_LENGTH = 70000000L;
    private HttpURLConnection connection;
    private OutputStream stream;
    private boolean empty = true;
    private BulkResult result = new BulkResult();
    private long sentLength = 0L;

    public void connect() throws IOException {
        this.connection = this.openPostConnection(this.getBulkURL());
        this.connection.setDoOutput(true);
        this.stream = this.connection.getOutputStream();
    }

    private URL getBulkURL() throws MalformedURLException {
        return new URL(ElasticConfiguration.getInstance().getUrl() + "_bulk/");
    }

    public void index(BulkIndex bulkIndex, Map<String, Object> fields) throws IOException {
        this.doOperation("index", bulkIndex, fields);
    }

    public void update(BulkIndex bulkIndex, Map<String, Object> fields) throws IOException {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        doc.put("doc", fields);
        this.doOperation("update", bulkIndex, doc);
    }

    public void delete(BulkIndex bulkIndex) throws IOException {
        this.doOperation("delete", bulkIndex, null);
    }

    public void doOperation(String operation, BulkIndex bulkIndex, Map<String, Object> fields) throws IOException {
        int dataLength;
        HashMap<String, BulkIndex> index = new HashMap<String, BulkIndex>();
        index.put(operation, bulkIndex);
        byte[] indexStr = mapper.writeValueAsBytes(index);
        byte[] fieldsStr = new byte[]{};
        if (fields != null) {
            fieldsStr = mapper.writeValueAsBytes(fields);
        }
        if (this.sentLength + (long)(dataLength = indexStr.length + fieldsStr.length) > 70000000L) {
            this.getResult();
            this.connect();
        }
        this.empty = false;
        this.stream.write(indexStr);
        this.stream.write("\n".getBytes());
        if (fields != null) {
            this.stream.write(fieldsStr);
            this.stream.write("\n".getBytes());
        }
        this.sentLength += (long)dataLength;
    }

    public BulkResult getResult() throws IOException {
        if (this.empty) {
            this.connection.disconnect();
        } else {
            this.stream.close();
            this.result.merge(this.readResult(this.connection, BulkResult.class));
        }
        this.sentLength = 0L;
        return this.result;
    }

    public void disconnect() {
        this.connection.disconnect();
    }
}

