/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.delete;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kz.arta.util.index.conf.ElasticConfiguration;
import kz.arta.util.index.elastic.HttpBasicOperation;
import kz.arta.util.index.elastic.delete.DeleteDocOperationResult;
import kz.arta.util.index.elastic.search.ElasticQuery;
import kz.arta.util.index.elastic.search.ElasticSearchRequest;
import kz.arta.util.index.elastic.search.SearchOperation;
import kz.arta.util.index.elastic.search.SearchResult;

public class DeleteDocumentOperation
extends HttpBasicOperation {
    public DeleteDocOperationResult delete(String indexName, String typeName, String id) throws IOException {
        HttpURLConnection connection = this.openDeleteConnection(this.geDeleteURL(id, indexName, typeName));
        DeleteDocOperationResult result = new DeleteDocOperationResult();
        return this.readResult(connection, DeleteDocOperationResult.class, result, 404);
    }

    public List<SearchResult.Hit> searchDataToDelete(String indexPattern, String typeName, ElasticQuery searchQuery, String ... fields) throws IOException {
        ElasticSearchRequest searchRequest = new ElasticSearchRequest();
        searchRequest.setFrom(0);
        searchRequest.setSize(10);
        searchRequest.setSource(fields != null && fields.length > 0 ? Arrays.asList(fields) : Collections.singletonList("empty"));
        searchRequest.setQuery(searchQuery);
        SearchOperation searchOperation = new SearchOperation(indexPattern, typeName);
        SearchResult result = searchOperation.search(searchRequest);
        return result.getHits().getHits();
    }

    private URL geDeleteURL(String id, String indexName, String typeName) throws MalformedURLException {
        return new URL(ElasticConfiguration.getInstance().getUrl() + indexName + "/" + typeName + "/" + id);
    }
}

