/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kz.arta.util.index.elastic.search.ElasticQuery;
import kz.arta.util.index.utils.QueryBuilder;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=Serializer.class)
public class ElasticBooleanQuery
implements ElasticQuery {
    private List<ElasticQuery> must = new ArrayList<ElasticQuery>();
    private List<ElasticQuery> mustNot = new ArrayList<ElasticQuery>();
    private List<ElasticQuery> should = new ArrayList<ElasticQuery>();
    private Integer minimumShouldMath;

    public void add(ElasticQuery q, QueryBuilder.Occur occur) {
        switch (occur) {
            case MUST: {
                this.getMust().add(q);
                return;
            }
            case SHOULD: {
                this.getShould().add(q);
                return;
            }
            case MUST_NOT: {
                this.getMustNot().add(q);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown occur type");
    }

    public boolean isEmpty() {
        return this.getMust().isEmpty() && this.getShould().isEmpty() && this.getMustNot().isEmpty();
    }

    public boolean isSingleShould() {
        return this.getMust().isEmpty() && this.getMustNot().isEmpty() && this.getShould().size() == 1;
    }

    public List<ElasticQuery> getMust() {
        return this.must;
    }

    public void setMust(List<ElasticQuery> must) {
        this.must = must;
    }

    public List<ElasticQuery> getMustNot() {
        return this.mustNot;
    }

    public void setMustNot(List<ElasticQuery> mustNot) {
        this.mustNot = mustNot;
    }

    public List<ElasticQuery> getShould() {
        return this.should;
    }

    public void setShould(List<ElasticQuery> should) {
        this.should = should;
    }

    public Integer getMinimumShouldMath() {
        return this.minimumShouldMath;
    }

    public void setMinimumShouldMath(Integer minimumShouldMath) {
        this.minimumShouldMath = minimumShouldMath;
    }

    public static class Serializer
    extends JsonSerializer<ElasticBooleanQuery> {
        public void serialize(ElasticBooleanQuery q, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("bool");
            try {
                jsonGenerator.writeStartObject();
                this.writeBlock(jsonGenerator, q.getMust(), QueryBuilder.Occur.MUST);
                this.writeBlock(jsonGenerator, q.getMustNot(), QueryBuilder.Occur.MUST_NOT);
                this.writeBlock(jsonGenerator, q.getShould(), QueryBuilder.Occur.SHOULD);
                if (q.getMinimumShouldMath() != null) {
                    jsonGenerator.writeNumberField("minimum_should_match", q.getMinimumShouldMath().intValue());
                }
                jsonGenerator.writeEndObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            jsonGenerator.writeEndObject();
        }

        private void writeBlock(JsonGenerator jsonGenerator, List<ElasticQuery> qs, QueryBuilder.Occur occur) throws IOException, JsonProcessingException {
            if (qs.isEmpty()) {
                return;
            }
            jsonGenerator.writeFieldName(occur.getJsonValue());
            if (qs.size() == 1) {
                jsonGenerator.writeObject((Object)qs.get(0));
            } else {
                jsonGenerator.writeStartArray();
                for (ElasticQuery q : qs) {
                    jsonGenerator.writeObject((Object)q);
                }
                jsonGenerator.writeEndArray();
            }
        }
    }
}

