/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.search;

import java.io.IOException;
import kz.arta.util.index.elastic.search.ElasticQuery;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=Serializer.class)
public class ElasticTermQuery
implements ElasticQuery {
    private String field;
    private String value;
    private Float boost = null;
    private boolean phrase = false;

    public ElasticTermQuery() {
    }

    public ElasticTermQuery(String field, String value) {
        this.field = field;
        this.value = value;
    }

    public Float getBoost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.boost = Float.valueOf(boost);
    }

    public boolean isPhrase() {
        return this.phrase;
    }

    public void setPhrase(boolean phrase) {
        this.phrase = phrase;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static class Serializer
    extends JsonSerializer<ElasticTermQuery> {
        public void serialize(ElasticTermQuery property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            if (property.isPhrase()) {
                jsonGenerator.writeFieldName("match_phrase");
            } else {
                jsonGenerator.writeFieldName("match");
            }
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(property.getField());
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("query");
            jsonGenerator.writeString(property.getValue());
            if (property.getBoost() != null) {
                jsonGenerator.writeFieldName("boost");
                jsonGenerator.writeNumber(property.getBoost().floatValue());
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }
}

