/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.elastic.stat;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import kz.arta.util.index.conf.ElasticConfiguration;
import kz.arta.util.index.data.Index;
import kz.arta.util.index.elastic.HttpBasicOperation;
import org.codehaus.jackson.JsonNode;

public class StatsOperation
extends HttpBasicOperation {
    private String indexPref;

    public Index.IndexInfo getIndexInfo(String indexPref) throws IOException {
        this.indexPref = indexPref;
        HttpURLConnection connection = this.openGetConnection(this.getURL());
        JsonNode result = this.readJsonResult(connection);
        Index.IndexInfo.Builder indexInfo = Index.IndexInfo.newBuilder();
        JsonNode all = result.get("_all");
        JsonNode total = all.get("total");
        JsonNode docs = total.get("docs");
        JsonNode store = total.get("store");
        indexInfo.setCount(docs.get("count").getIntValue());
        indexInfo.setDeleted(docs.get("deleted").getIntValue());
        indexInfo.setSizeInBbytes(store.get("size_in_bytes").getLongValue());
        return indexInfo.build();
    }

    private URL getURL() throws MalformedURLException {
        return new URL(ElasticConfiguration.getInstance().getUrl() + this.indexPref + "*/_stats");
    }
}

