/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.index.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ComplexDateFormat {
    private String[] formats;
    private SimpleDateFormat mainFormat;
    private List<SimpleDateFormat> dateFormats = new ArrayList<SimpleDateFormat>();

    public ComplexDateFormat(String mainFormat, String ... formats) {
        this.formats = formats;
        this.mainFormat = new SimpleDateFormat(mainFormat);
    }

    public String format(Date date) {
        return this.mainFormat.format(date);
    }

    public Date parse(String formatted) throws ParseException {
        try {
            return this.mainFormat.parse(formatted);
        }
        catch (ParseException parseException) {
            this.initFormats();
            for (SimpleDateFormat sdf : this.dateFormats) {
                try {
                    return sdf.parse(formatted);
                }
                catch (ParseException parseException2) {
                }
            }
            throw new ParseException("Not suitable string", 0);
        }
    }

    private void initFormats() {
        if (this.formats == null) {
            return;
        }
        for (String format : this.formats) {
            this.dateFormats.add(new SimpleDateFormat(format));
        }
        this.formats = null;
    }
}

