/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.util.lock;

import java.util.ArrayList;
import java.util.List;
import kz.arta.util.lock.LockObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockManager.class);
    String name = "";
    private final List<LockObject> objects = new ArrayList<LockObject>();

    public LockManager(String name) {
        this.name = name;
    }

    public LockManager() {
        Exception e = new Exception();
        this.name = e.getStackTrace()[1].getClassName();
    }

    public void execute(Object newObjectID) {
        this.execute(newObjectID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Object newObjectID, boolean join) {
        assert (newObjectID != null) : "Object cannot be null!";
        boolean needWait = false;
        Object object = null;
        List<LockObject> list = this.objects;
        synchronized (list) {
            for (LockObject lockObject : this.objects) {
                if (lockObject == null || !lockObject.objectID.equals(newObjectID)) continue;
                ++lockObject.threadsCount;
                needWait = true;
                object = lockObject;
                break;
            }
            if (needWait && join) {
                return true;
            }
            if (!needWait) {
                LockObject lockObject = new LockObject();
                lockObject.objectID = newObjectID;
                lockObject.threadsCount = 1;
                lockObject.time = System.nanoTime();
                this.objects.add(lockObject);
            }
        }
        if (needWait) {
            try {
                list = object;
                synchronized (list) {
                    object.wait();
                }
            }
            catch (Exception exc) {
                LOGGER.error(exc.getMessage(), (Throwable)exc);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(Object newObjectID) {
        List<LockObject> list = this.objects;
        synchronized (list) {
            for (LockObject object : this.objects) {
                if (!object.objectID.equals(newObjectID)) continue;
                return true;
            }
        }
        return false;
    }

    public void finished(Object objectID) {
        this.finished(objectID, false);
    }

    public void finished(Object ... objectIDs) {
        for (Object objectID : objectIDs) {
            if (objectID == null) continue;
            this.finished(objectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(Object objectID, boolean joined) {
        assert (objectID != null) : "Object cannot be null!";
        Object object = null;
        List<LockObject> list = this.objects;
        synchronized (list) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (this.objects.get((int)i).objectID == null || !this.objects.get((int)i).objectID.equals(objectID)) continue;
                --this.objects.get((int)i).threadsCount;
                if (this.objects.get((int)i).threadsCount == 0) {
                    this.objects.remove(i);
                    break;
                }
                object = this.objects.get(i);
            }
        }
        if (object != null && !joined) {
            list = object;
            synchronized (list) {
                object.notify();
            }
        }
    }
}

