/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.mysql;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.arta.synergy.datasource.mysql.ArtaMysqlConfigDefaultFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArtaMysqlConfigManager
implements ArtaMysqlConfigDefaultFields {
    private static Logger LOGGER = LoggerFactory.getLogger(ArtaMysqlConfigManager.class);
    private static String ear_name = "Synergy";

    ArtaMysqlConfigManager() {
    }

    public static void initialize() {
        ArtaMysqlConfigManager.initDocExents();
        ear_name = ArtaMysqlConfigManager.getEarName();
        String cfgFolder = ArtaMysqlConfigManager.getCfgURL();
        LOGGER.info("JBoss cfg directory is " + cfgFolder + ". Trying read settings from it");
        try {
            File file = new File(ArtaMysqlConfigManager.getConfFilePath("arta/management/db.properties"));
            if (!file.exists()) {
                throw new RuntimeException("File " + file.getAbsolutePath() + " does not exist!");
            }
            FileInputStream fis = new FileInputStream(file);
            props.load(fis);
            fis.close();
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            LOGGER.error("Failed to read settings from " + cfgFolder);
        }
        try {
            if (ear_name != null && ear_name.length() > 0) {
                LOGGER.debug("Going to read jcr mapped resource name");
            }
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
        }
    }

    private static void initDocExents() {
        String docQueue = "java:jboss/exported/jms/queue/DocIndex";
        HashSet<String> queue = new HashSet<String>();
        queue.add("java:jboss/exported/jms/queue/DocIndex");
    }

    public static String getEarName() {
        String classLoader = Thread.currentThread().getContextClassLoader().toString();
        Pattern p = Pattern.compile("(?:deployment.)([A-Za-z0-9_-[.]]+)(.ear)");
        Matcher m = p.matcher(classLoader);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String getCfgURL() {
        String cfgDir = System.getProperty("jboss.server.config.url");
        if (cfgDir == null) {
            cfgDir = System.getProperty("jboss.server.config.dir");
            cfgDir = cfgDir != null ? "file://" + cfgDir : "file:///home/topa/services/jboss/server/default/conf";
        }
        return cfgDir;
    }

    public static String getCfgDirectory() {
        String cfgDir = System.getProperty("jboss.server.config.url");
        if (cfgDir != null && cfgDir.startsWith("file://")) {
            try {
                URL url = new URL(cfgDir);
                return url.getFile();
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (cfgDir == null) {
            cfgDir = System.getProperty("jboss.server.config.dir");
            if (cfgDir != null) {
                return cfgDir;
            }
            return "/home/topa/services/jboss/server/default/conf";
        }
        return cfgDir;
    }

    public static String getSynergyDS() {
        if (ear_name.equals("Synergy")) {
            return "java:/SynergyDS";
        }
        return "java:jboss/datasources/" + ear_name + "/synergy";
    }

    public static String getConfFilePath(String relativePath) {
        if (ear_name == null || ear_name.equals("Synergy")) {
            return ArtaMysqlConfigManager.getCfgDirectory() + "/" + relativePath;
        }
        return ArtaMysqlConfigManager.getCfgDirectory() + "/" + ear_name + "/" + relativePath;
    }

    static {
        ArtaMysqlConfigManager.initialize();
    }
}

