/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.utils;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloserUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloserUtil.class);

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void close(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void close(ResultSet res) {
        if (res == null) {
            return;
        }
        try {
            res.close();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }
}

