/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.datasource.utils;

import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import kz.arta.synergy.datasource.mysql.ConnectionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtil.class);

    public static Connection getXAConnection() {
        Connection con = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(ConnectionUtil.getSynergyDS());
            con = ds.getConnection();
            return new ConnectionImpl(con);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ConnectionUtil.closeConnection(con);
            throw new IllegalStateException(e);
        }
    }

    public static void closeConnection(Connection con) {
        try {
            con.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getSynergyDS() {
        return "java:/SynergyDS";
    }
}

