/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ASFData {
    private List<Data> data = new ArrayList<Data>();

    public List<Data> getData() {
        return this.data;
    }

    public Data getData(String cmpID) {
        for (Data data : this.data) {
            if (data == null || data.getId() == null || !data.getId().equals(cmpID)) continue;
            return data;
        }
        return null;
    }

    public void setData(List<Data> data) {
        this.data = data;
    }

    public void addData(Data data) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.data == null || this.data.get(i) == null || this.data.get(i).getId() == null || !this.data.get(i).getId().equals(data.getId())) continue;
            this.data.remove(i);
            this.data.add(data);
            return;
        }
        this.data.add(data);
    }

    public void removeData(String cmpID) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.data == null || this.data.get(i) == null || this.data.get(i).getId() == null || !this.data.get(i).getId().equals(cmpID)) continue;
            this.data.remove(i);
            return;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Data {
        private String id;
        private String type;
        private String label;
        private String value;
        private String key;
        private String valueID;
        private String username;
        private String userID;
        private List<String> values;
        private List<String> keys;
        private List<Data> data;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        private String formatVersion;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        private Map<String, String> manualTags;

        public String getFormatVersion() {
            return this.formatVersion;
        }

        public void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        public Map<String, String> getManualTags() {
            return this.manualTags;
        }

        public void setManualTags(Map<String, String> manualTags) {
            this.manualTags = manualTags;
        }

        public String getId() {
            return this.id;
        }

        public Data setId(String id) {
            this.id = id;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public Data setValue(String value) {
            this.value = value;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValueID() {
            return this.valueID;
        }

        public void setValueID(String valueID) {
            this.valueID = valueID;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getUserID() {
            return this.userID;
        }

        public void setUserID(String userID) {
            this.userID = userID;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public List<String> getKeys() {
            return this.keys;
        }

        public void setKeys(List<String> keys) {
            this.keys = keys;
        }

        public List<Data> getData() {
            return this.data;
        }

        public void setData(List<Data> data) {
            this.data = data;
        }

        public Data getData(String cmpID) {
            if (this.data != null) {
                for (Data d : this.data) {
                    if (!d.getId().equalsIgnoreCase(cmpID)) continue;
                    return d;
                }
            }
            return null;
        }

        @JsonIgnore
        public Set<String> getBlockSet() {
            if (this.data != null) {
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                for (Data d : this.data) {
                    if (d == null || d.getId().lastIndexOf("-b") <= 0) continue;
                    set.add(d.getId().substring(d.getId().lastIndexOf("-b") + 1));
                }
                return set;
            }
            return null;
        }

        @JsonIgnore
        public int getLastBlockNumber() {
            int lastBlockNumber = 0;
            Set<String> blocks = this.getBlockSet();
            if (blocks != null) {
                for (String block : blocks) {
                    int blockNum = 0;
                    try {
                        blockNum = Integer.parseInt(block.substring(1).trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (blockNum <= lastBlockNumber) continue;
                    lastBlockNumber = blockNum;
                }
            }
            return lastBlockNumber;
        }
    }
}

