/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kz.arta.synergy.forms.common.object.ASFDataSources;
import kz.arta.synergy.forms.common.object.ASFDefaultValue;
import kz.arta.synergy.forms.common.object.ASFPageLayout;
import kz.arta.synergy.forms.common.object.ASFPointer;
import kz.arta.synergy.forms.common.object.ASFProperty;
import kz.arta.synergy.forms.common.object.View;
import kz.arta.synergy.forms.common.object.WidgetType;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ASFDefinition {
    private String uuid;
    private String name;
    private String nameru;
    private String namekz;
    private String code;
    private String description;
    private String type;
    private int version;
    private List<ASFProperty> properties;
    private ASFPageLayout layout;
    private List<ASFPointer> pointers;
    private List<ASFDefaultValue> data;
    private List<ASFDataSources> datasources;
    private List<View> views;

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<ASFProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ASFProperty> properties) {
        this.properties = properties;
    }

    public List<View> getViews() {
        return this.views;
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    public ASFPageLayout getLayout() {
        return this.layout;
    }

    public void setLayout(ASFPageLayout layout) {
        this.layout = layout;
    }

    public ASFProperty getASFProperty(String cmpID) {
        return this.getASFProperty(cmpID, true);
    }

    public ASFProperty getASFProperty(String cmpID, boolean includeInner) {
        if (this.properties != null && cmpID != null) {
            for (ASFProperty property : this.properties) {
                if (cmpID.equalsIgnoreCase(property.getId())) {
                    return property;
                }
                if (!includeInner || property.getProperties() == null) continue;
                for (ASFProperty innerProperty : property.getProperties()) {
                    if (!cmpID.equalsIgnoreCase(innerProperty.getId())) continue;
                    return innerProperty;
                }
            }
        }
        return null;
    }

    public List<ASFPointer> getPointers() {
        return this.pointers;
    }

    public void setPointers(List<ASFPointer> pointers) {
        this.pointers = pointers;
    }

    public List<ASFDefaultValue> getData() {
        return this.data;
    }

    public void setData(List<ASFDefaultValue> data) {
        this.data = data;
    }

    public String getNameru() {
        return this.nameru;
    }

    public void setNameru(String nameru) {
        this.nameru = nameru;
    }

    public String getNamekz() {
        return this.namekz;
    }

    public void setNamekz(String namekz) {
        this.namekz = namekz;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<WidgetType, List<String>> indexOf(Set<WidgetType> widgetTypes) {
        HashMap<WidgetType, List<String>> result = new HashMap<WidgetType, List<String>>();
        for (WidgetType type : widgetTypes) {
            result.put(type, new ArrayList());
        }
        this.addWidgets(result, this.properties, null);
        return result;
    }

    private void addWidgets(Map<WidgetType, List<String>> result, List<ASFProperty> properties, String prefix) {
        prefix = prefix == null ? "" : prefix + ".";
        for (ASFProperty property : properties) {
            WidgetType type;
            if (!WidgetType.contains(property.getType())) continue;
            if (property.getProperties() != null) {
                String intPrefix = null;
                if (property.getConfig() != null && property.getConfig().isAppendRows()) {
                    intPrefix = property.getId();
                }
                this.addWidgets(result, property.getProperties(), intPrefix);
            }
            if (!result.containsKey((Object)(type = WidgetType.valueOf(property.getType())))) continue;
            result.get((Object)type).add(prefix + property.getId());
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<ASFDataSources> getDatasources() {
        return this.datasources;
    }

    public void setDatasources(List<ASFDataSources> datasources) {
        this.datasources = datasources;
    }

    public String getName(String lang) {
        if (lang.equals("kz")) {
            return this.getNamekz();
        }
        if (lang.equals("en")) {
            return this.getName();
        }
        return this.getNameru();
    }
}

