/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object;

import kz.arta.synergy.forms.common.object.ASFProperty;

public enum WidgetType {
    label("FWLabel", false),
    textbox("FWText", true, true),
    textarea("FWTextArea", true, true),
    listbox("FWListBox", true, true),
    radio("FWRadionList", true, true),
    check("FWCheckList", true, true),
    date("FWDate", true, true),
    table("FWTable", false),
    entity("FWSynergyEntity", true, true),
    image("FWStaticImage", false),
    file("FWFileAttachment", false, true),
    filelink("FWFileLink", false, true),
    userchooser("FWUserChooser", true, true),
    counter("FWCounter"),
    signlist("FWSignList", false),
    resolutionlist("FWResolutionsList", false),
    htd("FWHtdEditor", true, true),
    doclink("FWSynergyDocLink", false, true),
    link("FWLink", true, true),
    processlist("FWProcessHistoryList", false),
    repeater("FWRepeatInput", true, true),
    reglink("FWSynergyRegLink", true, true),
    projectlink("FWSynergyProjLink", true, true),
    personlink("FWSynergyPersonLink", true, true),
    appendable_table("FWAppendableTable"),
    custom("FWCustom", true),
    users("FWDUser"),
    departments("FWDepartmentChooser", true, true),
    positions("FWPositionChooser", true, true),
    docnumber("FWDocNumber", false),
    numericinput("FWNumericInput", true, true),
    errorlabel("FWErrorLabel", false),
    page("FWDPage", false);

    private final boolean input;
    private final boolean editable;
    private final String className;

    private WidgetType(String className) {
        this(className, true, false);
    }

    private WidgetType(String className, boolean input) {
        this(className, input, false);
    }

    private WidgetType(String className, boolean input, boolean editable) {
        this.input = input;
        this.className = className;
        this.editable = editable;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isInput() {
        return this.input;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public static boolean contains(String widgetType) {
        return WidgetType.getFromString(widgetType) != null;
    }

    public static WidgetType getFromString(String typeStr) {
        for (WidgetType type : WidgetType.values()) {
            if (!type.name().equals(typeStr)) continue;
            return type;
        }
        return null;
    }

    public static WidgetType getFromProperty(ASFProperty property) {
        if (property == null) {
            return null;
        }
        return WidgetType.getFromString(property.getType());
    }

    public boolean notSortingViewField() {
        return this.isInput() && this != appendable_table;
    }

    public boolean shouldLoadDataToGetValue() {
        return this == doclink || this == filelink || this == table || this == check;
    }
}

