/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object.printer;

import java.util.ArrayList;
import java.util.List;

public class ColumnWidth {
    private List<Double> width = new ArrayList<Double>();
    private List<Boolean> columnHaveWidth = new ArrayList<Boolean>();
    private double ratio = 1.0;
    private double outWidth = 21.0;
    private int numberOfColumns = 0;

    public ColumnWidth(int numberOfColumns, double outWidthCM) {
        this.numberOfColumns = numberOfColumns;
        this.outWidth = outWidthCM;
        if (this.width.size() != 0) {
            this.width.clear();
            this.columnHaveWidth.clear();
        }
        for (int i = 0; i < numberOfColumns; ++i) {
            this.width.add(this.outWidth / (double)numberOfColumns);
            this.columnHaveWidth.add(false);
        }
    }

    public ColumnWidth(int numberOfColumns, double outWidth, double ratioForCM) {
        this.numberOfColumns = numberOfColumns;
        this.outWidth = outWidth * ratioForCM;
        this.ratio = ratioForCM;
        if (this.width.size() != 0) {
            this.width.clear();
            this.columnHaveWidth.clear();
        }
        for (int i = 0; i < numberOfColumns; ++i) {
            this.width.add(outWidth / (double)numberOfColumns);
            this.columnHaveWidth.add(false);
        }
    }

    public void setRatio(double ratioForCM) {
        this.ratio = ratioForCM;
    }

    public void setColumnSize(int numberColumn, double columnWidth) {
        this.columnHaveWidth.set(numberColumn, true);
        this.width.set(numberColumn, columnWidth * this.ratio);
        this.allResize();
    }

    private void allResize() {
        double tempAllsize = 0.0;
        int notSized = 0;
        for (int i = 0; i < this.columnHaveWidth.size(); ++i) {
            if (this.columnHaveWidth.get(i).booleanValue()) {
                tempAllsize += this.width.get(i).doubleValue();
                continue;
            }
            ++notSized;
        }
        if (tempAllsize > this.outWidth) {
            this.nullForAllNotWidth();
        } else {
            double tempAitoWhidth = (this.outWidth - tempAllsize) / (double)notSized;
            for (int i = 0; i < this.columnHaveWidth.size(); ++i) {
                if (this.columnHaveWidth.get(i).booleanValue()) continue;
                this.width.set(i, tempAitoWhidth);
            }
        }
    }

    private void nullForAllNotWidth() {
        for (int i = 0; i < this.columnHaveWidth.size(); ++i) {
            if (this.columnHaveWidth.get(i).booleanValue()) continue;
            this.width.set(i, 0.0);
        }
    }

    public double getColumnWidthCM(int i) {
        if (i >= this.numberOfColumns) {
            return 0.0;
        }
        return this.width.get(i);
    }
}

