/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object.translation;

import java.io.Serializable;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityText
implements Serializable {
    private String localeID;
    private String text;
    private String defaultText;
    private boolean editByUser;

    public EntityText() {
    }

    public EntityText(String localeID, String text, boolean setByUser) {
        this.text = text != null ? text : "";
        this.defaultText = text;
        this.setEditByUser(setByUser);
        this.setLocaleID(localeID);
    }

    public String getLocaleID() {
        return this.localeID;
    }

    public void setLocaleID(String localeID) {
        this.localeID = localeID;
        this.ensureRightEditBy();
    }

    private void ensureRightEditBy() {
        if ("c".equals(this.localeID)) {
            this.editByUser = true;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text != null ? text : "";
    }

    public boolean isEditByUser() {
        return this.editByUser;
    }

    public void setEditByUser(boolean editByUser) {
        this.editByUser = editByUser;
        this.ensureRightEditBy();
    }

    public boolean isDefault() {
        return "c".equals(this.localeID);
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public void updateDefaulText() {
        this.defaultText = this.text;
    }

    public boolean isEmptyDefault() {
        return this.isDefault() && this.getText().isEmpty();
    }

    public static EntityText createFrom(EntityText other) {
        EntityText entityText = new EntityText();
        entityText.copyFrom(other);
        return entityText;
    }

    public void copyFrom(EntityText other) {
        this.setText(other.getText());
        this.setDefaultText(other.getDefaultText());
        this.setLocaleID(other.getLocaleID());
        this.setEditByUser(other.isEditByUser());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityText that = (EntityText)o;
        return this.editByUser == that.editByUser && Objects.equals(this.localeID, that.localeID) && Objects.equals(this.text, that.text) && Objects.equals(this.defaultText, that.defaultText);
    }

    public int hashCode() {
        return Objects.hash(this.localeID, this.text, this.defaultText, this.editByUser);
    }
}

