/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.object.translation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kz.arta.synergy.forms.common.object.translation.EntityText;

public class EntityTranslation
implements Serializable {
    public static final String DEFAULT_LOCALE = "c";
    public static final long NEW_TRANSLATION_ID = 0L;
    public static final long WITHOUT_TRANSLATION_ID = -1L;
    private long translationID;
    private int objectType;
    private List<EntityText> translations = new ArrayList<EntityText>();
    private List<String> localeIDs = new ArrayList<String>();
    boolean localTranslation;

    public EntityTranslation() {
    }

    public EntityTranslation(long translationID, int objectType, List<EntityText> translations, List<String> locales2) {
        this(translationID, objectType, translations);
        this.localeIDs = locales2;
        this.createNotExistTranslations();
    }

    public EntityTranslation(long translationID, int objectType, List<EntityText> translations) {
        this.translationID = translationID;
        this.objectType = objectType;
        this.translations = translations;
    }

    public EntityTranslation(String text, int objectType) {
        this.objectType = objectType;
        this.localTranslation = true;
        this.translations.add(new EntityText(DEFAULT_LOCALE, text, false));
    }

    public static EntityTranslation createFromSingle(String text, int objectType) {
        ArrayList<EntityText> translations = new ArrayList<EntityText>();
        translations.add(new EntityText(DEFAULT_LOCALE, text, true));
        return new EntityTranslation(0L, objectType, translations);
    }

    public boolean isNewTranslation() {
        return this.translationID == 0L;
    }

    public boolean isLocalTranslation() {
        return this.localTranslation;
    }

    private void createNotExistTranslations() {
        String cText = "";
        for (EntityText entityText : this.translations) {
            if (entityText.isDefault()) {
                cText = entityText.getText();
            }
            this.localeIDs.remove(entityText.getLocaleID());
        }
        for (String locale : this.localeIDs) {
            this.translations.add(new EntityText(locale, cText, false));
        }
    }

    public String getLocaleText(String locale) {
        String cText = "";
        for (EntityText translation : this.translations) {
            if (translation.getLocaleID().equals(locale)) {
                return translation.getText();
            }
            if (!translation.isDefault()) continue;
            cText = translation.getText();
        }
        return cText;
    }

    public String getDefaultText() {
        return this.getLocaleText(DEFAULT_LOCALE);
    }

    public EntityText getEntityText(String locale) {
        EntityText entity = this.getEntity(locale);
        if (entity != null) {
            return entity;
        }
        return this.getDefaultEntity();
    }

    public EntityText getDefaultEntity() {
        return this.getEntity(DEFAULT_LOCALE);
    }

    public EntityText getEntity(String locale) {
        for (EntityText translation : this.translations) {
            if (!translation.getLocaleID().equals(locale)) continue;
            return translation;
        }
        return null;
    }

    public String getAllTranslationString() {
        if (this.translations != null) {
            StringBuilder stringBuffer = new StringBuilder();
            for (EntityText text : this.translations) {
                stringBuffer.append(text.getText()).append(" ");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public long getTranslationID() {
        return this.translationID;
    }

    public void setTranslationID(long translationID) {
        this.translationID = translationID;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setObjectType(int objectType) {
        this.objectType = objectType;
    }

    public List<EntityText> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<EntityText> translations) {
        this.translations = translations;
    }

    public List<String> getLocaleIDs() {
        return this.localeIDs;
    }

    public void setLocaleIDs(List<String> localeIDs) {
        this.localeIDs = localeIDs;
    }

    public void reset() {
        for (EntityText text : this.translations) {
            text.setText(text.getDefaultText());
        }
    }

    public void saveDefaults() {
        for (EntityText text : this.translations) {
            text.updateDefaulText();
        }
    }

    public EntityTranslation copy() {
        EntityTranslation translation = new EntityTranslation();
        translation.setTranslationID(this.getTranslationID());
        translation.setObjectType(this.getObjectType());
        translation.setLocaleIDs(new ArrayList<String>(this.localeIDs));
        ArrayList<EntityText> texts = new ArrayList<EntityText>();
        for (EntityText entityText : this.translations) {
            texts.add(EntityText.createFrom(entityText));
        }
        translation.setTranslations(texts);
        return translation;
    }

    public EntityTranslation copyAsNew(int objectType) {
        EntityTranslation translation = new EntityTranslation(this.getDefaultText(), objectType);
        translation.setTranslationID(0L);
        translation.setTranslations(this.getTranslations());
        return translation;
    }

    public boolean isEmpty() {
        for (EntityText translation : this.translations) {
            String text = translation.getText();
            if (text == null || text.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTranslation that = (EntityTranslation)o;
        return this.translationID == that.translationID && this.objectType == that.objectType && this.localTranslation == that.localTranslation && Objects.equals(this.translations, that.translations) && Objects.equals(this.localeIDs, that.localeIDs);
    }

    public int hashCode() {
        return Objects.hash(this.translationID, this.objectType, this.translations, this.localeIDs, this.localTranslation);
    }
}

