/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.shared.utils.numeric;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import kz.arta.synergy.forms.common.shared.utils.numeric.objects.CalcItem;

public class CalcUtil {
    public static final String MINUS = "-";

    public static String calc(String sourceString) {
        if (sourceString == null || "".equals(sourceString) || !"=".equals(sourceString.substring(0, 1))) {
            return null;
        }
        return CalcUtil.process(CalcUtil.parse(sourceString));
    }

    private static CalcItem parse(String sourceString) {
        StringBuilder processRow = new StringBuilder();
        CalcItem items = new CalcItem();
        CalcItem.Value curValue = new CalcItem.Value();
        curValue.setStart(1);
        CalcItem.Znak znak = new CalcItem.Znak();
        for (int currentPos = 1; currentPos < sourceString.length(); ++currentPos) {
            String s = sourceString.substring(currentPos, currentPos + 1);
            if (CalcItem.Operator.isCaontaintValue(s)) {
                if (MINUS.equals(s)) {
                    if (CalcItem.Operator.isCaontaintValue(sourceString.substring(currentPos - 1, currentPos)) || sourceString.substring(currentPos - 1, currentPos).equals("=")) {
                        processRow.append(s);
                        continue;
                    }
                    items.getValues().add(CalcUtil.subInitCurValue(curValue, processRow, currentPos));
                    curValue = new CalcItem.Value();
                    items.getZnaks().add(CalcUtil.initNewZnak(curValue, znak, currentPos, s));
                    continue;
                }
                items.getValues().add(CalcUtil.subInitCurValue(curValue, processRow, currentPos));
                curValue = new CalcItem.Value();
                items.getZnaks().add(CalcUtil.initNewZnak(curValue, znak, currentPos, s));
                continue;
            }
            processRow.append(s);
        }
        items.getValues().add(CalcUtil.subInitCurValue(curValue, processRow, sourceString.length()));
        return items;
    }

    private static CalcItem.Znak initNewZnak(CalcItem.Value curValue, CalcItem.Znak znak, int currentPos, String s) {
        curValue.setStart(currentPos + 1);
        znak.setStart(currentPos);
        znak.setEnd(currentPos + 1);
        znak.setOperator(CalcItem.Operator.getOperator(s));
        return znak.clon();
    }

    private static CalcItem.Value subInitCurValue(CalcItem.Value curValue, StringBuilder processRow, int currentPos) {
        curValue.setVal(CalcUtil.createBD(processRow.toString()));
        processRow.delete(0, processRow.length());
        curValue.setEnd(currentPos);
        return curValue;
    }

    private static BigDecimal createBD(String value) {
        return new BigDecimal(Double.parseDouble(value), MathContext.DECIMAL64).setScale(18, 4);
    }

    private static String process(CalcItem itmems) {
        List<CalcItem.Znak> znaksPrior = itmems.getZnaksPrior();
        ArrayList<CalcItem.Znak> znaksNotPrior = itmems.getZnaksNotPrior();
        CalcUtil.process(znaksPrior, itmems);
        CalcUtil.process(znaksNotPrior, itmems);
        return itmems.getValues().get(0).getVal().toPlainString();
    }

    private static void process(List<CalcItem.Znak> znaks, CalcItem itmems) {
        for (CalcItem.Znak znak : znaks) {
            CalcItem.Value lValue = itmems.getByEndValue(znak.getStart());
            CalcItem.Value rValue = itmems.getByStartValue(znak.getEnd());
            CalcItem.Value newValue = CalcUtil.doZN(lValue, znak, rValue);
            itmems.getValues().remove(lValue);
            itmems.getValues().remove(rValue);
            itmems.getValues().add(newValue);
        }
    }

    private static CalcItem.Value doZN(CalcItem.Value lValue, CalcItem.Znak znak, CalcItem.Value rValue) {
        CalcItem.Value result = new CalcItem.Value();
        result.setStart(lValue.getStart());
        result.setEnd(rValue.getEnd());
        switch (znak.getOperator()) {
            case MULTIPLY: {
                result.setVal(lValue.getVal().multiply(rValue.getVal()));
                break;
            }
            case DIVIDE: {
                result.setVal(lValue.getVal().divide(rValue.getVal(), 18, 4));
                break;
            }
            case ADD: {
                result.setVal(lValue.getVal().add(rValue.getVal()));
                break;
            }
            case SUBTRACT: {
                result.setVal(lValue.getVal().subtract(rValue.getVal()));
            }
        }
        return result;
    }
}

