/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.shared.utils.numeric;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kz.arta.synergy.forms.common.object.NumericInputSettings;

public class NumericBuilder {
    private NumericInputSettings.DropOrRound dropOrRound = NumericInputSettings.DropOrRound.DROP;
    private boolean restrictionPlacesAct = false;
    private int restrictionPlacesValue = 18;
    private String decimalSeparator = ".";
    private boolean thousandsSeparatorAct = false;
    private String thousandsSeparatorValue = "";
    private long cValue;

    public NumericInputSettings.DropOrRound getDropOrRound() {
        return this.dropOrRound;
    }

    public NumericBuilder setDropOrRound(NumericInputSettings.DropOrRound dropOrRound) {
        this.dropOrRound = dropOrRound;
        return this;
    }

    public boolean isRestrictionPlacesAct() {
        return this.restrictionPlacesAct;
    }

    public NumericBuilder setRestrictionPlacesAct(boolean restrictionPlacesAct) {
        this.restrictionPlacesAct = restrictionPlacesAct;
        return this;
    }

    public int getRestrictionPlacesValue() {
        return this.restrictionPlacesValue;
    }

    public NumericBuilder setRestrictionPlacesValue(int restrictionPlacesValue) {
        this.restrictionPlacesValue = restrictionPlacesValue;
        return this;
    }

    public NumericInputSettings.DecimalSeparator getDecimalSeparator() {
        if (".".equals(this.decimalSeparator)) {
            return NumericInputSettings.DecimalSeparator.DOT;
        }
        if (",".equals(this.decimalSeparator)) {
            return NumericInputSettings.DecimalSeparator.COMMA;
        }
        if ("".equals(this.decimalSeparator)) {
            return NumericInputSettings.DecimalSeparator.EMPTY;
        }
        return NumericInputSettings.DecimalSeparator.DOT;
    }

    public NumericBuilder setDecimalSeparator(NumericInputSettings.DecimalSeparator decimalSeparator) {
        switch (decimalSeparator) {
            case DOT: {
                this.decimalSeparator = ".";
                break;
            }
            case COMMA: {
                this.decimalSeparator = ",";
                break;
            }
            case EMPTY: {
                this.decimalSeparator = "";
            }
        }
        return this;
    }

    public boolean isThousandsSeparatorAct() {
        return this.thousandsSeparatorAct;
    }

    public NumericBuilder setThousandsSeparatorAct(boolean thousandsSeparatorAct) {
        this.thousandsSeparatorAct = thousandsSeparatorAct;
        return this;
    }

    public String getThousandsSeparatorValue() {
        return this.thousandsSeparatorValue;
    }

    public NumericBuilder setThousandsSeparatorValue(String thousandsSeparatorValue) {
        this.thousandsSeparatorValue = thousandsSeparatorValue;
        return this;
    }

    public synchronized String buildStringValue(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        String decimalSign = ".";
        if (value.contains(",")) {
            value = value.replace(",", ".");
            decimalSign = ",";
        }
        if (this.restrictionPlacesAct) {
            if (this.dropOrRound == NumericInputSettings.DropOrRound.ROUND) {
                BigDecimal bigDecimal = new BigDecimal(value);
                bigDecimal = bigDecimal.setScale(this.restrictionPlacesValue, 4);
                value = bigDecimal.toPlainString();
            } else {
                int pointPlace = value.indexOf(".");
                if (pointPlace > -1 && value.length() - pointPlace - 1 > this.restrictionPlacesValue) {
                    value = value.substring(0, pointPlace + 1 + this.restrictionPlacesValue);
                }
            }
        }
        int pointPlace = value.indexOf(".");
        String integerPart = value;
        String decimalPart = "";
        if (pointPlace != -1) {
            integerPart = value.substring(0, pointPlace);
            decimalPart = value.substring(pointPlace + 1);
        }
        if (this.restrictionPlacesAct) {
            while (decimalPart.length() < this.restrictionPlacesValue) {
                decimalPart = decimalPart + "0";
            }
        }
        if (this.isThousandsSeparatorAct()) {
            integerPart = integerPart.replaceAll("\\B(?=(\\d{3})+(?!\\d))", this.thousandsSeparatorValue);
        }
        if (decimalPart.length() > 0) {
            return integerPart + this.decimalSeparator + decimalPart;
        }
        return integerPart;
    }

    public synchronized String buildNumericValue(String value) {
        return new NumericBuilder().setDropOrRound(this.dropOrRound).setRestrictionPlacesAct(this.restrictionPlacesAct).setRestrictionPlacesValue(this.restrictionPlacesAct ? this.restrictionPlacesValue : 18).setDecimalSeparator(NumericInputSettings.DecimalSeparator.DOT).setThousandsSeparatorAct(false).buildStringValue(value);
    }

    private String getDValue(String dValue, int dcValue) {
        int i;
        StringBuffer result = new StringBuffer();
        StringBuffer dresult = new StringBuffer();
        dresult.append(this.decimalSeparator);
        List<Integer> dec = new ArrayList<Integer>();
        for (i = 0; i < dcValue; ++i) {
            dec.add(0);
        }
        if (!dValue.equals("0") && this.getNormalZeroCount(false) - dcValue > 0) {
            int step = 0;
            for (char c : dValue.toCharArray()) {
                dec.set(step, Integer.parseInt(String.valueOf(c)));
                ++step;
            }
            if (this.restrictionPlacesAct && this.dropOrRound == NumericInputSettings.DropOrRound.ROUND && this.getNormalZeroCount(true) < dec.size()) {
                for (int i2 = dec.size(); i2 > this.getNormalZeroCount(true) - dcValue; --i2) {
                    if ((Integer)dec.get(i2 - 1) < 5) continue;
                    if (i2 - 2 >= 0) {
                        dec.set(i2 - 2, dec.get(i2 - 2) + 1);
                        continue;
                    }
                    this.cValue = 1L;
                }
                dec = this.normalDec(dec);
            }
            for (int i3 = 0; i3 < this.getNormalZeroCount(true); ++i3) {
                if (i3 < dec.size()) {
                    dresult.append(dec.get(i3));
                    continue;
                }
                if (!this.restrictionPlacesAct) continue;
                dresult.append(0);
            }
        } else if (this.restrictionPlacesAct) {
            for (i = 0; i < this.getNormalZeroCount(true) - dcValue; ++i) {
                dresult.append(0);
            }
        }
        if (this.isThousandsSeparatorAct()) {
            result.append(this.getCThousands(this.cValue));
        } else {
            result.append(this.cValue);
        }
        if (dresult.toString().equals(this.decimalSeparator)) {
            dresult.delete(0, dresult.length());
        }
        result.append(dresult);
        return result.toString();
    }

    private int getNormalZeroCount(boolean isRoundDo) {
        return !this.restrictionPlacesAct ? 18 : (!isRoundDo ? this.restrictionPlacesValue + 1 : this.restrictionPlacesValue);
    }

    private List<Integer> normalDec(List<Integer> dec) {
        for (int i = this.getNormalZeroCount(true) - 1; i >= 0; --i) {
            if (dec.size() <= i || dec.get(i) <= 9) continue;
            if (i > 0) {
                dec.set(i - 1, dec.get(i - 1) + 1);
            } else {
                ++this.cValue;
            }
            dec.set(i, 0);
        }
        return dec;
    }

    private String getCThousands(long cValue) {
        StringBuilder result = new StringBuilder();
        if (cValue < 1000L) {
            result.append(String.valueOf(cValue));
            return result.toString();
        }
        boolean isFirst = true;
        do {
            if (!isFirst) {
                result.insert(0, this.thousandsSeparatorValue);
            }
            result.insert(0, this.getThousandSet(cValue));
            isFirst = false;
        } while ((cValue /= 1000L) != 0L);
        return result.toString();
    }

    private String getThousandSet(long cValue) {
        StringBuilder result = new StringBuilder(String.valueOf(cValue % 1000L));
        if (result.length() != 3 && cValue / 1000L > 0L) {
            for (int i = result.length(); i < 3; ++i) {
                result.insert(0, "0");
            }
        }
        return result.toString();
    }
}

