/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.shared.utils.numeric.objects;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class CalcItem {
    private ArrayList<Znak> znaks = new ArrayList();
    private ArrayList<Value> values = new ArrayList();

    public ArrayList<Value> getValues() {
        return this.values;
    }

    public ArrayList<Znak> getZnaks() {
        return this.znaks;
    }

    public List<Znak> getZnaks(Operator operator) {
        ArrayList<Znak> result = new ArrayList<Znak>();
        for (Znak z : this.znaks) {
            if (!operator.equals((Object)z.getOperator())) continue;
            result.add(z);
        }
        return result;
    }

    public List<Znak> getZnaksPrior() {
        ArrayList<Znak> result = new ArrayList<Znak>();
        for (Znak z : this.znaks) {
            if (!Operator.MULTIPLY.equals((Object)z.getOperator()) && !Operator.DIVIDE.equals((Object)z.getOperator())) continue;
            result.add(z);
        }
        return result;
    }

    public ArrayList<Znak> getZnaksNotPrior() {
        ArrayList<Znak> result = new ArrayList<Znak>();
        for (Znak z : this.znaks) {
            if (!Operator.SUBTRACT.equals((Object)z.getOperator()) && !Operator.ADD.equals((Object)z.getOperator())) continue;
            result.add(z);
        }
        return result;
    }

    public Value getByEndValue(int pos) {
        for (Value val : this.values) {
            if (val.getEnd() != pos) continue;
            return val;
        }
        return null;
    }

    public Value getByStartValue(int pos) {
        for (Value val : this.values) {
            if (val.getStart() != pos) continue;
            return val;
        }
        return null;
    }

    public static enum Operator {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static boolean isCaontaintValue(String value) {
            for (Operator znak : Operator.values()) {
                if (!znak.getValue().equals(value)) continue;
                return true;
            }
            return false;
        }

        public static Operator getOperator(String s) {
            for (Operator operator : Operator.values()) {
                if (!operator.getValue().equals(s)) continue;
                return operator;
            }
            return null;
        }
    }

    public static class Znak {
        private int start = Integer.MAX_VALUE;
        private Operator operator;
        private int end = Integer.MIN_VALUE;

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public void setOperator(Operator operator) {
            this.operator = operator;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public Znak clon() {
            Znak result = new Znak();
            result.start = this.start;
            result.end = this.end;
            result.operator = this.operator;
            return result;
        }
    }

    public static class Value {
        private BigDecimal val;
        private int start = 0;
        private int end = 0;

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public String getString() {
            return this.val.toPlainString();
        }

        public void setVal(BigDecimal val) {
            this.val = val;
        }

        public BigDecimal getVal() {
            return this.val;
        }
    }
}

