/*
 * Decompiled with CFR 0.152.
 */
package kz.arta.synergy.forms.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.arta.synergy.forms.common.object.ASFData;
import kz.arta.synergy.forms.common.object.ASFDataWrapper;
import kz.arta.synergy.forms.common.object.WidgetType;

public class ASFDataUtils {
    private static final Pattern BLOCK_ID_PATTERN = Pattern.compile("(.*)-b([0-9]{1,})$");

    public static boolean hasBIndex(String id) {
        return BLOCK_ID_PATTERN.matcher(id).matches();
    }

    public static String getBindex(String id) {
        Matcher matcher = BLOCK_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(2);
    }

    public static String getBlockComponentId(String id) {
        Matcher matcher = BLOCK_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            return id;
        }
        return matcher.group(1);
    }

    public static int getIntBindex(String id) {
        String bIndex = ASFDataUtils.getBindex(id);
        if (bIndex == null || bIndex.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(bIndex);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static ASFData.Data addData(String id, WidgetType type, ASFData.Data parent, String key, String value) {
        return ASFDataUtils.addData(id, type, parent.getData(), key, value);
    }

    public static ASFData.Data addData(String id, WidgetType type, List<ASFData.Data> datas, String key, String value) {
        ASFData.Data data = new ASFData.Data();
        data.setId(id);
        data.setType(type.name());
        data.setValue(value);
        data.setKey(key);
        datas.add(data);
        return data;
    }

    public static ASFData.Data addData(String id, WidgetType type, ASFDataWrapper parent, String key, String value) {
        return ASFDataUtils.addData(id, type, parent.getData(), key, value);
    }

    public static ASFData.Data getCmpData(ASFDataWrapper asfData, WidgetType type, String cmpID) {
        ASFData.Data data = asfData.getData(cmpID);
        if (data == null) {
            data = ASFDataUtils.addData(cmpID, type, asfData.getData(), null, null);
            if (type == WidgetType.appendable_table) {
                data.setData(new ArrayList<ASFData.Data>());
            }
        }
        return data;
    }

    public static void setData(String id, WidgetType type, ASFData.Data reserveTable, String key, String value) {
        ASFData.Data data = reserveTable.getData(id);
        if (data == null) {
            data = ASFDataUtils.addData(id, type, reserveTable, null, null);
        }
        data.setValue(value);
        data.setKey(key);
    }

    public static void setData(String id, WidgetType type, ASFDataWrapper reserveTable, String key, String value) {
        ASFData.Data data = reserveTable.getData(id);
        if (data == null) {
            data = ASFDataUtils.addData(id, type, reserveTable, null, null);
        }
        data.setValue(value);
        data.setKey(key);
    }
}

